/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.namesrv;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class GetProjectGroupCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "getProjectGroup";
    }

    @Override
    public String commandDesc() {
        return "Get project group by server ip or project group name.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "ip", true, "set the server ip");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "project", true, "set the project group");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption("i")) {
                String ip = commandLine.getOptionValue('i').trim();
                defaultMQAdminExt.start();
                String project = defaultMQAdminExt.getProjectGroupByIp(ip);
                System.out.printf("ip=%s, projectGroup=%s\n", ip, project);
            } else if (commandLine.hasOption("p")) {
                String project = commandLine.getOptionValue('p').trim();
                defaultMQAdminExt.start();
                String ips = defaultMQAdminExt.getIpsByProjectGroup(project);
                if (UtilAll.isBlank((String)ips)) {
                    System.out.printf("No ip in project group[%s]\n", project);
                } else {
                    System.out.printf("projectGroup=%s, ips=%s\n", project, ips);
                }
            } else {
                ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

