/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.offset;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class GetConsumerStatusCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "getConsumerStatus";
    }

    @Override
    public String commandDesc() {
        return "get consumer status from client.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("g", "group", true, "set the consumer group");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "set the topic");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("i", "originClientId", true, "set the consumer clientId");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String group = commandLine.getOptionValue("g").trim();
            String topic = commandLine.getOptionValue("t").trim();
            String originClientId = "";
            if (commandLine.hasOption("i")) {
                originClientId = commandLine.getOptionValue("i").trim();
            }
            defaultMQAdminExt.start();
            Map<String, Map<MessageQueue, Long>> consumerStatusTable = defaultMQAdminExt.getConsumeStatus(topic, group, originClientId);
            System.out.printf("get consumer status from client. group=%s, topic=%s, originClientId=%s\n", group, topic, originClientId);
            System.out.printf("%-50s  %-15s  %-15s  %-20s\n", "#clientId", "#brokerName", "#queueId", "#offset");
            for (String clientId : consumerStatusTable.keySet()) {
                Map<MessageQueue, Long> mqTable = consumerStatusTable.get(clientId);
                for (MessageQueue mq : mqTable.keySet()) {
                    System.out.printf("%-50s  %-15s  %-15d  %-20d\n", UtilAll.frontStringAtLeast((String)clientId, (int)50), mq.getBrokerName(), mq.getQueueId(), mqTable.get(mq));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    public static void main(String[] args) {
        System.setProperty("rocketmq.namesrv.addr", "127.0.0.1:9876");
        GetConsumerStatusCommand cmd = new GetConsumerStatusCommand();
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        String[] subargs = new String[]{"-t qatest_TopicTest", "-g qatest_consumer_broadcast"};
        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])subargs, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
        cmd.execute(commandLine, options, null);
    }
}

