/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.topic;

import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.protocol.body.ClusterInfo;
import com.alibaba.rocketmq.common.protocol.body.GroupList;
import com.alibaba.rocketmq.common.protocol.body.TopicList;
import com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class TopicListSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "topicList";
    }

    @Override
    public String commandDesc() {
        return "Fetch all topic list from name server";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterModel", false, "clusterModel");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    private String findTopicBelongToWhichCluster(String topic, ClusterInfo clusterInfo, DefaultMQAdminExt defaultMQAdminExt) throws RemotingException, MQClientException, InterruptedException {
        TopicRouteData topicRouteData = defaultMQAdminExt.examineTopicRouteInfo(topic);
        BrokerData brokerData = (BrokerData)topicRouteData.getBrokerDatas().get(0);
        String brokerName = brokerData.getBrokerName();
        for (Map.Entry next : clusterInfo.getClusterAddrTable().entrySet()) {
            if (!((Set)next.getValue()).contains(brokerName)) continue;
            return (String)next.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        block12: {
            DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
            defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
            try {
                defaultMQAdminExt.start();
                if (commandLine.hasOption('c')) {
                    ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
                    System.out.printf("%-20s  %-48s  %-48s\n", "#Cluster Name", "#Topic", "#Consumer Group");
                    TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
                    for (String topic : topicList.getTopicList()) {
                        if (topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%")) continue;
                        String clusterName = "";
                        GroupList groupList = new GroupList();
                        try {
                            clusterName = this.findTopicBelongToWhichCluster(topic, clusterInfo, defaultMQAdminExt);
                            groupList = defaultMQAdminExt.queryTopicConsumeByWho(topic);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (null == groupList || groupList.getGroupList().isEmpty()) {
                            groupList = new GroupList();
                            groupList.getGroupList().add("");
                        }
                        for (String group : groupList.getGroupList()) {
                            System.out.printf("%-20s  %-48s  %-48s\n", UtilAll.frontStringAtLeast((String)clusterName, (int)20), UtilAll.frontStringAtLeast((String)topic, (int)48), UtilAll.frontStringAtLeast((String)group, (int)48));
                        }
                    }
                    break block12;
                }
                TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
                for (String topic : topicList.getTopicList()) {
                    System.out.println(topic);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                defaultMQAdminExt.shutdown();
            }
        }
    }
}

