/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.topic;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.admin.TopicOffset;
import com.alibaba.rocketmq.common.admin.TopicStatsTable;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class TopicStatusSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "topicStatus";
    }

    @Override
    public String commandDesc() {
        return "Examine topic Status info";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            String topic = commandLine.getOptionValue('t').trim();
            TopicStatsTable topicStatsTable = defaultMQAdminExt.examineTopicStats(topic);
            LinkedList mqList = new LinkedList();
            mqList.addAll(topicStatsTable.getOffsetTable().keySet());
            Collections.sort(mqList);
            System.out.printf("%-32s  %-4s  %-20s  %-20s    %s\n", "#Broker Name", "#QID", "#Min Offset", "#Max Offset", "#Last Updated");
            for (MessageQueue mq : mqList) {
                TopicOffset topicOffset = (TopicOffset)topicStatsTable.getOffsetTable().get(mq);
                String humanTimestamp = "";
                if (topicOffset.getLastUpdateTimestamp() > 0L) {
                    humanTimestamp = UtilAll.timeMillisToHumanString2((long)topicOffset.getLastUpdateTimestamp());
                }
                System.out.printf("%-32s  %-4d  %-20d  %-20d    %s\n", UtilAll.frontStringAtLeast((String)mq.getBrokerName(), (int)32), mq.getQueueId(), topicOffset.getMinOffset(), topicOffset.getMaxOffset(), humanTimestamp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

