/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.command.topic;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.srvutil.ServerUtil;
import com.alibaba.rocketmq.tools.admin.DefaultMQAdminExt;
import com.alibaba.rocketmq.tools.command.SubCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class UpdateOrderConfCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "updateOrderConf";
    }

    @Override
    public String commandDesc() {
        return "Create or update or delete order conf";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("v", "orderConf", true, "set order conf [eg. brokerName1:num;brokerName2:num]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "method", true, "option type [eg. put|get|delete");
        opt.setRequired(true);
        options.addOption(opt);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String topic = commandLine.getOptionValue('t').trim();
            String type = commandLine.getOptionValue('m').trim();
            if ("get".equals(type)) {
                defaultMQAdminExt.start();
                String orderConf = defaultMQAdminExt.getKVConfig("ORDER_TOPIC_CONFIG", topic);
                System.out.printf("get orderConf success. topic=[%s], orderConf=[%s] ", topic, orderConf);
                return;
            }
            if ("put".equals(type)) {
                defaultMQAdminExt.start();
                String orderConf = "";
                if (commandLine.hasOption('v')) {
                    orderConf = commandLine.getOptionValue('v').trim();
                }
                if (UtilAll.isBlank((String)orderConf)) {
                    throw new Exception("please set orderConf with option -v.");
                }
                defaultMQAdminExt.createOrUpdateOrderConf(topic, orderConf, true);
                System.out.printf("update orderConf success. topic=[%s], orderConf=[%s]", topic, orderConf.toString());
                return;
            }
            if ("delete".equals(type)) {
                defaultMQAdminExt.start();
                defaultMQAdminExt.deleteKvConfig("ORDER_TOPIC_CONFIG", topic);
                System.out.printf("delete orderConf success. topic=[%s]", topic);
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

