/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.tools.monitor;

import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.alibaba.rocketmq.tools.monitor.DeleteMsgsEvent;
import com.alibaba.rocketmq.tools.monitor.FailedMsgs;
import com.alibaba.rocketmq.tools.monitor.MonitorListener;
import com.alibaba.rocketmq.tools.monitor.UndoneMsgs;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;

public class DefaultMonitorListener
implements MonitorListener {
    private final Logger log = ClientLogger.getLog();
    private static final String LogPrefix = "[MONITOR] ";
    private static final String LogNotify = "[MONITOR]  [NOTIFY] ";

    @Override
    public void beginRound() {
        this.log.info("[MONITOR] =========================================beginRound");
    }

    @Override
    public void reportUndoneMsgs(UndoneMsgs undoneMsgs) {
        this.log.info(String.format("[MONITOR] reportUndoneMsgs: %s", undoneMsgs));
    }

    @Override
    public void reportFailedMsgs(FailedMsgs failedMsgs) {
        this.log.info(String.format("[MONITOR] reportFailedMsgs: %s", failedMsgs));
    }

    @Override
    public void reportDeleteMsgsEvent(DeleteMsgsEvent deleteMsgsEvent) {
        this.log.info(String.format("[MONITOR] reportDeleteMsgsEvent: %s", deleteMsgsEvent));
    }

    @Override
    public void reportConsumerRunningInfo(TreeMap<String, ConsumerRunningInfo> criTable) {
        boolean result = ConsumerRunningInfo.analyzeSubscription(criTable);
        if (!result) {
            this.log.info(String.format("[MONITOR]  [NOTIFY] reportConsumerRunningInfo: ConsumerGroup: %s, Subscription different", criTable.firstEntry().getValue().getProperties().getProperty("consumerGroup")));
        }
        for (Map.Entry<String, ConsumerRunningInfo> next : criTable.entrySet()) {
            String result2 = ConsumerRunningInfo.analyzeProcessQueue((String)next.getKey(), (ConsumerRunningInfo)next.getValue());
            if (result2 == null || result2.isEmpty()) continue;
            this.log.info(String.format("[MONITOR]  [NOTIFY] reportConsumerRunningInfo: ConsumerGroup: %s, ClientId: %s, %s", criTable.firstEntry().getValue().getProperties().getProperty("consumerGroup"), next.getKey(), result2));
        }
    }

    @Override
    public void endRound() {
        this.log.info("[MONITOR] =========================================endRound");
    }
}

