/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redis;

import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.redis.RedisCache;
import com.alicp.jetcache.redis.RedisCacheConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class RedisCacheBuilder<T extends ExternalCacheBuilder<T>>
extends ExternalCacheBuilder<T> {
    public static RedisCacheBuilderImpl createRedisCacheBuilder() {
        return new RedisCacheBuilderImpl();
    }

    protected RedisCacheBuilder() {
        this.buildFunc(config -> new RedisCache((RedisCacheConfig)((Object)config)));
    }

    public RedisCacheConfig getConfig() {
        if (this.config == null) {
            this.config = new RedisCacheConfig();
        }
        return (RedisCacheConfig)this.config;
    }

    public T jedisPool(Pool<Jedis> pool) {
        this.getConfig().setJedisPool(pool);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.getConfig().setJedisPool(jedisPool);
    }

    public T readFromSlave(boolean readFromSlave) {
        this.getConfig().setReadFromSlave(readFromSlave);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setReadFromSlave(boolean readFromSlave) {
        this.getConfig().setReadFromSlave(readFromSlave);
    }

    public T jedisSlavePools(Pool<Jedis> ... jedisSlavePools) {
        this.getConfig().setJedisSlavePools(jedisSlavePools);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setJedisSlavePools(Pool<Jedis> ... jedisSlavePools) {
        this.getConfig().setJedisSlavePools(jedisSlavePools);
    }

    public T slaveReadWeights(int ... slaveReadWeights) {
        this.getConfig().setSlaveReadWeights(slaveReadWeights);
        return (T)((ExternalCacheBuilder)this.self());
    }

    public void setSlaveReadWeights(int ... slaveReadWeights) {
        this.getConfig().setSlaveReadWeights(slaveReadWeights);
    }

    public static class RedisCacheBuilderImpl
    extends RedisCacheBuilder<RedisCacheBuilderImpl> {
    }
}

