/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public abstract class AbstractFieldSpecificSerializer
extends AbstractSerializer {
    protected Field[] _fields;

    public AbstractFieldSpecificSerializer(Class<?> clazz) {
        this._fields = this.getFieldsForSerialize(clazz);
    }

    @Override
    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (obj == null) {
            out.writeNull();
            return;
        }
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        int ref = out.writeObjectBegin(cl.getName());
        if (ref < -1) {
            this.writeObject10(obj, out);
        } else {
            if (ref == -1) {
                this.writeDefinition20(out);
                out.writeObjectBegin(cl.getName());
            }
            this.writeInstance(obj, out);
        }
    }

    private void writeObject10(Object obj, AbstractHessianOutput out) throws IOException {
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            out.writeString(field.getName());
            this.serializeField(out, obj, field);
        }
        out.writeMapEnd();
    }

    private void writeDefinition20(AbstractHessianOutput out) throws IOException {
        out.writeClassFieldLength(this._fields.length);
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            out.writeString(field.getName());
        }
    }

    public void writeInstance(Object obj, AbstractHessianOutput out) throws IOException {
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            this.serializeField(out, obj, field);
        }
    }

    protected abstract void serializeField(AbstractHessianOutput var1, Object var2, Field var3) throws IOException;

    protected Field[] getFieldsForSerialize(Class cl) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (cl != null) {
            Field[] originFields = cl.getDeclaredFields();
            for (int i = 0; i < originFields.length; ++i) {
                Field field = originFields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            cl = cl.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }
}

