/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.atomic;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.BasicDeserializer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicDeserializer
extends AbstractDeserializer {
    private Class<?> _type;
    private BasicDeserializer intArrayDsr = new BasicDeserializer(17);
    private BasicDeserializer longArrayDsr = new BasicDeserializer(18);
    private BasicDeserializer objectArrayDsr = new BasicDeserializer(23);

    public AtomicDeserializer(Class<?> cl) {
        this._type = cl;
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        if (AtomicInteger.class.equals(this._type)) {
            return new AtomicInteger(in.readInt());
        }
        if (AtomicBoolean.class.equals(this._type)) {
            return new AtomicBoolean(in.readInt() == 1);
        }
        if (AtomicLong.class.equals(this._type)) {
            return new AtomicLong(in.readLong());
        }
        if (AtomicReference.class.equals(this._type)) {
            return new AtomicReference<Object>(in.readObject());
        }
        if (AtomicIntegerArray.class.equals(this._type)) {
            int[] res = (int[])this.intArrayDsr.readObject(in);
            int len = res.length;
            AtomicIntegerArray array = new AtomicIntegerArray(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            return array;
        }
        if (AtomicLongArray.class.equals(this._type)) {
            long[] res = (long[])this.longArrayDsr.readObject(in);
            int len = res.length;
            AtomicLongArray array = new AtomicLongArray(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            return array;
        }
        if (AtomicReferenceArray.class.equals(this._type)) {
            Object[] res = (Object[])in.readObject(new Object[0].getClass());
            int len = res.length;
            AtomicReferenceArray<Object> array = new AtomicReferenceArray<Object>(len);
            for (int i = 0; i < len; ++i) {
                array.set(i, res[i]);
            }
            return array;
        }
        throw new UnsupportedOperationException(String.valueOf(this));
    }
}

