/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha1Hash(File file) throws IOException {
        String string;
        DigestInputStream inputStream = new DigestInputStream(new FileInputStream(file), MessageDigest.getInstance("SHA-1"));
        try {
            byte[] buffer = new byte[4098];
            while (inputStream.read(buffer) != -1) {
            }
            string = FileUtils.bytesToHex(inputStream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }
        inputStream.close();
        return string;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }

    public static File createTempDir(String subPath) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        File tempDir = new File(baseDir, subPath);
        if (tempDir.exists()) {
            return tempDir;
        }
        if (tempDir.mkdir()) {
            return tempDir;
        }
        throw new ArkRuntimeException("Failed to create temp file");
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
    }
}

