/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ClassUtils {
    public static String getPackageName(String className) {
        AssertUtils.isFalse(StringUtils.isEmpty(className), "ClassName should not be empty!", new Object[0]);
        int index = className.lastIndexOf(46);
        if (index > 0) {
            return className.substring(0, index);
        }
        return ".";
    }

    public static List<String> collectClasses(File dir) throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        Collection classFiles = FileUtils.listFiles((File)dir, (String[])new String[]{"class"}, (boolean)true);
        String basePath = dir.getCanonicalPath();
        for (File classFile : classFiles) {
            String relativePath = classFile.getCanonicalPath().substring(basePath.length() + 1);
            String className = relativePath.replace(File.separatorChar, '.').replaceAll("\\.class$", "");
            if (className.contains("$")) continue;
            classNames.add(className);
        }
        return classNames;
    }

    public static String getCodeBase(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ProtectionDomain domain = cls.getProtectionDomain();
        if (domain == null) {
            return null;
        }
        CodeSource source = domain.getCodeSource();
        if (source == null) {
            return null;
        }
        URL location = source.getLocation();
        if (location == null) {
            return null;
        }
        return location.getFile();
    }
}

