/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.common.util;

import com.alipay.sofa.ark.common.util.ClassUtils;
import com.alipay.sofa.ark.common.util.StringUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class ParseUtils {
    public static void parsePackageNodeAndStem(Set<String> candidates, Set<String> stems, Set<String> nodes) {
        for (String pkgPattern : candidates) {
            if (pkgPattern.endsWith("*")) {
                stems.add(ClassUtils.getPackageName(pkgPattern));
                continue;
            }
            nodes.add(pkgPattern);
        }
    }

    public static void parseResourceAndStem(Set<String> candidates, Set<String> prefixStems, Set<String> suffixStems, Set<String> resources) {
        for (String candidate : candidates) {
            if (candidate.equals("*")) continue;
            if (candidate.endsWith("*")) {
                prefixStems.add(candidate.substring(0, candidate.length() - "*".length()));
                continue;
            }
            if (candidate.startsWith("*")) {
                suffixStems.add(candidate.substring("*".length()));
                continue;
            }
            resources.add(candidate);
        }
    }

    public static void parseExcludeConf(LinkedHashSet<String> targetSet, String origin, String confKey) {
        String confVal;
        if (origin.startsWith(confKey + "=") && !StringUtils.isEmpty(confVal = origin.split("=")[1]) && !targetSet.contains(confVal)) {
            targetSet.add(confVal);
        }
    }
}

