/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap.dubbo;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.dubbo.DubboSingleton;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Extension(value="dubbo")
public class DubboConsumerBootstrap<T>
extends ConsumerBootstrap<T> {
    private ReferenceConfig<T> referenceConfig;
    protected volatile transient T proxyIns;

    protected DubboConsumerBootstrap(ConsumerConfig<T> consumerConfig) {
        super(consumerConfig);
    }

    @Override
    public synchronized T refer() {
        if (this.proxyIns != null) {
            return this.proxyIns;
        }
        this.referenceConfig = new ReferenceConfig();
        this.covert(this.consumerConfig, this.referenceConfig);
        this.proxyIns = this.referenceConfig.get();
        return this.proxyIns;
    }

    private void covert(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        this.copyCommon(consumerConfig, referenceConfig);
        this.copyApplication(consumerConfig, referenceConfig);
        this.copyRegistries(consumerConfig, referenceConfig);
        this.copyConsumer(consumerConfig, referenceConfig);
        this.copyMethods(consumerConfig, referenceConfig);
    }

    private void copyCommon(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        referenceConfig.setInjvm(Boolean.valueOf(consumerConfig.isInJVM()));
    }

    private void copyApplication(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        ApplicationConfig applicationConfig = consumerConfig.getApplication();
        com.alibaba.dubbo.config.ApplicationConfig dubboConfig = new com.alibaba.dubbo.config.ApplicationConfig();
        dubboConfig.setName(applicationConfig.getAppName());
        referenceConfig.setApplication(dubboConfig);
    }

    private void copyRegistries(ConsumerConfig consumerConfig, ReferenceConfig referenceConfig) {
        List<RegistryConfig> registryConfigs = consumerConfig.getRegistry();
        if (CommonUtils.isNotEmpty(registryConfigs)) {
            ArrayList<com.alibaba.dubbo.config.RegistryConfig> dubboRegistryConfigs = new ArrayList<com.alibaba.dubbo.config.RegistryConfig>();
            for (RegistryConfig registryConfig : registryConfigs) {
                com.alibaba.dubbo.config.RegistryConfig dubboRegistryConfig = DubboSingleton.REGISTRY_MAP.get(registryConfig);
                if (dubboRegistryConfig == null) {
                    dubboRegistryConfig = new com.alibaba.dubbo.config.RegistryConfig();
                    this.copyRegistryFields(registryConfig, dubboRegistryConfig);
                    com.alibaba.dubbo.config.RegistryConfig old = DubboSingleton.REGISTRY_MAP.putIfAbsent(registryConfig, dubboRegistryConfig);
                    if (old != null) {
                        dubboRegistryConfig = old;
                    }
                }
                dubboRegistryConfigs.add(dubboRegistryConfig);
            }
            referenceConfig.setRegistries(dubboRegistryConfigs);
        }
    }

    private void copyRegistryFields(RegistryConfig registryConfig, com.alibaba.dubbo.config.RegistryConfig dubboRegistryConfig) {
        dubboRegistryConfig.setAddress(registryConfig.getAddress());
        dubboRegistryConfig.setProtocol(registryConfig.getProtocol());
        dubboRegistryConfig.setRegister(Boolean.valueOf(registryConfig.isRegister()));
        dubboRegistryConfig.setSubscribe(Boolean.valueOf(registryConfig.isSubscribe()));
        dubboRegistryConfig.setAddress(registryConfig.getAddress());
        dubboRegistryConfig.setTimeout(Integer.valueOf(registryConfig.getTimeout()));
        dubboRegistryConfig.setId(registryConfig.getId());
        dubboRegistryConfig.setParameters(registryConfig.getParameters());
    }

    private void copyConsumer(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        referenceConfig.setId(consumerConfig.getId());
        referenceConfig.setInterface(consumerConfig.getInterfaceId());
        referenceConfig.setGroup(consumerConfig.getUniqueId());
        referenceConfig.setVersion("1.0");
        referenceConfig.setActives(Integer.valueOf(consumerConfig.getConcurrents()));
        referenceConfig.setCluster(consumerConfig.getCluster());
        referenceConfig.setConnections(Integer.valueOf(consumerConfig.getConnectionNum()));
        referenceConfig.setRetries(Integer.valueOf(consumerConfig.getRetries()));
        referenceConfig.setProxy(consumerConfig.getProxy());
        referenceConfig.setTimeout(Integer.valueOf(consumerConfig.getTimeout()));
        referenceConfig.setUrl(consumerConfig.getDirectUrl());
        referenceConfig.setCheck(Boolean.valueOf(consumerConfig.isCheck()));
        referenceConfig.setLazy(Boolean.valueOf(consumerConfig.isLazy()));
        String invokeType = consumerConfig.getInvokeType();
        if (invokeType != null) {
            if ("oneway".equals(invokeType)) {
                referenceConfig.setSent(Boolean.valueOf(false));
            }
            if ("callback".equals(invokeType) || "future".equals(invokeType)) {
                referenceConfig.setAsync(Boolean.valueOf(true));
            }
        }
        referenceConfig.setParameters(consumerConfig.getParameters());
    }

    private void copyMethods(ConsumerConfig<T> consumerConfig, ReferenceConfig<T> referenceConfig) {
        Map<String, MethodConfig> methodConfigs = consumerConfig.getMethods();
        if (CommonUtils.isNotEmpty(methodConfigs)) {
            ArrayList<com.alibaba.dubbo.config.MethodConfig> dubboMethodConfigs = new ArrayList<com.alibaba.dubbo.config.MethodConfig>();
            for (Map.Entry<String, MethodConfig> entry : methodConfigs.entrySet()) {
                MethodConfig methodConfig = entry.getValue();
                com.alibaba.dubbo.config.MethodConfig dubboMethodConfig = new com.alibaba.dubbo.config.MethodConfig();
                dubboMethodConfig.setName(methodConfig.getName());
                dubboMethodConfig.setParameters(methodConfig.getParameters());
                dubboMethodConfig.setTimeout(methodConfig.getTimeout());
                dubboMethodConfig.setRetries(methodConfig.getRetries());
                String invokeType = methodConfig.getInvokeType();
                if (invokeType != null) {
                    if ("oneway".equals(invokeType)) {
                        dubboMethodConfig.setReturn(Boolean.valueOf(false));
                    }
                    if ("callback".equals(invokeType) || "future".equals(invokeType)) {
                        dubboMethodConfig.setAsync(Boolean.valueOf(true));
                    }
                }
                dubboMethodConfigs.add(dubboMethodConfig);
            }
            referenceConfig.setMethods(dubboMethodConfigs);
        }
    }

    @Override
    public synchronized void unRefer() {
        if (this.proxyIns == null) {
            return;
        }
        this.referenceConfig.destroy();
        this.proxyIns = null;
    }

    @Override
    public Cluster getCluster() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<ProviderGroup> subscribe() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isSubscribed() {
        return this.proxyIns != null;
    }

    @Override
    public T getProxyIns() {
        return this.proxyIns;
    }
}

