/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.event;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.Subscriber;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBus.class);
    private static final boolean EVENT_BUS_ENABLE = RpcConfigs.getBooleanValue("event.bus.enable");
    private static final ConcurrentHashMap<Class<? extends Event>, CopyOnWriteArraySet<Subscriber>> SUBSCRIBER_MAP = new ConcurrentHashMap();

    public static boolean isEnable() {
        return EVENT_BUS_ENABLE;
    }

    public static boolean isEnable(Class<? extends Event> eventClass) {
        return EVENT_BUS_ENABLE && CommonUtils.isNotEmpty(SUBSCRIBER_MAP.get(eventClass));
    }

    public static void register(Class<? extends Event> eventClass, Subscriber subscriber) {
        CopyOnWriteArraySet<Subscriber> old;
        CopyOnWriteArraySet<Subscriber> set = SUBSCRIBER_MAP.get(eventClass);
        if (set == null && (old = SUBSCRIBER_MAP.putIfAbsent(eventClass, set = new CopyOnWriteArraySet())) != null) {
            set = old;
        }
        set.add(subscriber);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Register subscriber: {} of event: {}.", subscriber, eventClass);
        }
    }

    public static void unRegister(Class<? extends Event> eventClass, Subscriber subscriber) {
        CopyOnWriteArraySet<Subscriber> set = SUBSCRIBER_MAP.get(eventClass);
        if (set != null) {
            set.remove(subscriber);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("UnRegister subscriber: {} of event: {}.", subscriber, eventClass);
            }
        }
    }

    public static void post(final Event event) {
        if (!EventBus.isEnable()) {
            return;
        }
        CopyOnWriteArraySet<Subscriber> subscribers = SUBSCRIBER_MAP.get(event.getClass());
        if (CommonUtils.isNotEmpty(subscribers)) {
            for (final Subscriber subscriber : subscribers) {
                if (subscriber.isSync()) {
                    EventBus.handleEvent(subscriber, event);
                    continue;
                }
                final RpcInternalContext context = RpcInternalContext.peekContext();
                AsyncRuntime.getAsyncThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RpcInternalContext.setContext(context);
                            EventBus.handleEvent(subscriber, event);
                        }
                        catch (Exception e) {
                            RpcInternalContext.removeContext();
                        }
                    }
                });
            }
        }
    }

    private static void handleEvent(Subscriber subscriber, Event event) {
        block2: {
            try {
                subscriber.onEvent(event);
            }
            catch (Throwable e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Handle " + event.getClass() + " error", e);
            }
        }
    }
}

