/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.local;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.MapDifference;
import com.alipay.sofa.rpc.common.struct.ScheduledService;
import com.alipay.sofa.rpc.common.struct.ValueDifference;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.local.LocalRegistryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@Extension(value="local")
public class LocalRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalRegistry.class);
    private ScheduledService scheduledExecutorService;
    protected Map<String, ProviderGroup> memoryCache = new ConcurrentHashMap<String, ProviderGroup>();
    private boolean needBackup = false;
    private boolean subscribe = true;
    protected Map<String, List<ConsumerConfig>> notifyListeners = new ConcurrentHashMap<String, List<ConsumerConfig>>();
    private long lastLoadTime;
    private int scanPeriod = 2000;
    private String regFile;

    protected LocalRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public void init() {
        this.regFile = this.registryConfig.getFile();
        if (this.regFile == null) {
            throw new SofaRpcRuntimeException("File of LocalRegistry is null");
        }
        this.lastLoadTime = LocalRegistryHelper.loadBackupFileToCache(this.regFile, this.memoryCache);
        this.scanPeriod = CommonUtils.parseInt(this.registryConfig.getParameter("registry.local.scan.period"), this.scanPeriod);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalRegistry.this.doWriteFile();
                    if (LocalRegistry.this.subscribe && LocalRegistryHelper.checkModified(LocalRegistry.this.regFile, LocalRegistry.this.lastLoadTime)) {
                        ConcurrentHashMap<String, ProviderGroup> tempCache = new ConcurrentHashMap<String, ProviderGroup>();
                        long currentTime = LocalRegistryHelper.loadBackupFileToCache(LocalRegistry.this.regFile, tempCache);
                        LocalRegistry.this.notifyConsumer(tempCache);
                        LocalRegistry.this.memoryCache = tempCache;
                        LocalRegistry.this.lastLoadTime = currentTime;
                    }
                }
                catch (Throwable e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        };
        this.scheduledExecutorService = new ScheduledService("LocalRegistry-Back-Load", 1, task, this.scanPeriod, this.scanPeriod, TimeUnit.MILLISECONDS).start();
    }

    protected void doWriteFile() {
        if (this.needBackup && LocalRegistryHelper.backup(this.regFile, this.memoryCache)) {
            this.needBackup = false;
        }
    }

    @Override
    public boolean start() {
        return false;
    }

    @Override
    public void register(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = LocalRegistryHelper.buildListDataId(config, server.getProtocol());
                ProviderInfo providerInfo = LocalRegistryHelper.convertProviderToProviderInfo(config, server);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00205", serviceName));
                }
                this.doRegister(appName, serviceName, providerInfo);
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, LogCodes.getLog("00206", serviceName));
            }
        }
    }

    protected void doRegister(String appName, String serviceName, ProviderInfo providerInfo) {
        ProviderGroup oldGroup;
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, LogCodes.getLog("00201", serviceName));
        }
        if ((oldGroup = this.memoryCache.get(serviceName)) != null) {
            oldGroup.add(providerInfo);
        } else {
            ArrayList<ProviderInfo> news = new ArrayList<ProviderInfo>();
            news.add(providerInfo);
            this.memoryCache.put(serviceName, new ProviderGroup(news));
        }
        this.needBackup = true;
        this.doWriteFile();
        if (this.subscribe) {
            this.notifyConsumerListeners(serviceName, this.memoryCache.get(serviceName));
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("00208"));
            }
            return;
        }
        if (!config.isRegister()) {
            return;
        }
        List<ServerConfig> serverConfigs = config.getServer();
        if (CommonUtils.isNotEmpty(serverConfigs)) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = LocalRegistryHelper.buildListDataId(config, server.getProtocol());
                ProviderInfo providerInfo = LocalRegistryHelper.convertProviderToProviderInfo(config, server);
                try {
                    this.doUnRegister(serviceName, providerInfo);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("00203", serviceName, "1"));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("00203", serviceName, "0"), e);
                }
            }
        }
    }

    protected void doUnRegister(String serviceName, ProviderInfo providerInfo) {
        ProviderGroup oldGroup = this.memoryCache.get(serviceName);
        if (oldGroup == null) {
            return;
        }
        oldGroup.remove(providerInfo);
        this.needBackup = true;
        this.doWriteFile();
        if (this.subscribe) {
            this.notifyConsumerListeners(serviceName, this.memoryCache.get(serviceName));
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unregistry", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        String key = LocalRegistryHelper.buildListDataId(config, config.getProtocol());
        List<ConsumerConfig> listeners = this.notifyListeners.get(key);
        if (listeners == null) {
            listeners = new ArrayList<ConsumerConfig>();
            this.notifyListeners.put(key, listeners);
        }
        listeners.add(config);
        ProviderGroup group = this.memoryCache.get(key);
        if (group == null) {
            group = new ProviderGroup();
            this.memoryCache.put(key, group);
        }
        return Collections.singletonList(group);
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        String key = LocalRegistryHelper.buildListDataId(config, config.getProtocol());
        List<ConsumerConfig> listeners = this.notifyListeners.get(key);
        if (listeners != null) {
            listeners.remove(config);
            if (listeners.size() == 0) {
                this.notifyListeners.remove(key);
            }
        }
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unSubscribe", e);
            }
        }
    }

    @Override
    public void destroy() {
        block3: {
            try {
                if (this.scheduledExecutorService != null) {
                    this.scheduledExecutorService.shutdown();
                    this.scheduledExecutorService = null;
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn(t.getMessage(), t);
            }
        }
    }

    private void notifyConsumer(Map<String, ProviderGroup> newCache) {
        Map<String, ProviderGroup> oldCache = this.memoryCache;
        MapDifference<String, ProviderGroup> difference = new MapDifference<String, ProviderGroup>(newCache, oldCache);
        Map<String, ProviderGroup> onlynew = difference.entriesOnlyOnLeft();
        for (Map.Entry<String, ProviderGroup> entry : onlynew.entrySet()) {
            this.notifyConsumerListeners(entry.getKey(), entry.getValue());
        }
        Map<String, ProviderGroup> onlyold = difference.entriesOnlyOnRight();
        for (Map.Entry<String, ProviderGroup> entry : onlyold.entrySet()) {
            this.notifyConsumerListeners(entry.getKey(), new ProviderGroup());
        }
        Map<String, ValueDifference<ProviderGroup>> changed = difference.entriesDiffering();
        for (Map.Entry<String, ValueDifference<ProviderGroup>> entry : changed.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} has differente", entry.getKey());
            }
            ValueDifference<ProviderGroup> differentValue = entry.getValue();
            ProviderGroup innew = differentValue.rightValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("new(right) is {}", innew);
            }
            this.notifyConsumerListeners(entry.getKey(), innew);
        }
    }

    private void notifyConsumerListeners(String serviceName, ProviderGroup providerGroup) {
        List<ConsumerConfig> consumerConfigs = this.notifyListeners.get(serviceName);
        if (consumerConfigs != null) {
            for (ConsumerConfig config : consumerConfigs) {
                ProviderInfoListener listener = config.getProviderInfoListener();
                if (listener == null) continue;
                listener.updateProviders(providerGroup);
            }
        }
    }
}

