/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.ProviderStatus;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.BeanUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.ReflectUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperRegistryHelper {
    static List<String> convertProviderToUrls(ProviderConfig providerConfig) {
        List<ServerConfig> servers = providerConfig.getServer();
        if (servers != null && !servers.isEmpty()) {
            ArrayList<String> urls = new ArrayList<String>();
            for (ServerConfig server : servers) {
                StringBuilder sb = new StringBuilder(200);
                String host = server.getVirtualHost();
                if (host == null && (NetUtils.isLocalHost(host = server.getHost()) || NetUtils.isAnyHost(host))) {
                    host = SystemInfo.getLocalHost();
                }
                sb.append(server.getProtocol()).append("://").append(host).append(":").append(server.getPort()).append(server.getContextPath()).append("?uniqueId=").append(providerConfig.getUniqueId()).append(ZookeeperRegistryHelper.getKeyPairs("version", "1.0")).append(ZookeeperRegistryHelper.getKeyPairs("timeout", providerConfig.getTimeout())).append(ZookeeperRegistryHelper.getKeyPairs("delay", providerConfig.getDelay())).append(ZookeeperRegistryHelper.getKeyPairs("id", providerConfig.getId())).append(ZookeeperRegistryHelper.getKeyPairs("dynamic", providerConfig.isDynamic())).append(ZookeeperRegistryHelper.getKeyPairs("weight", providerConfig.getWeight())).append(ZookeeperRegistryHelper.getKeyPairs("warmupTime", providerConfig.getParameter("warmupTime"))).append(ZookeeperRegistryHelper.getKeyPairs("warmupWeight", providerConfig.getParameter("warmupWeight"))).append(ZookeeperRegistryHelper.getKeyPairs("accepts", server.getAccepts())).append(ZookeeperRegistryHelper.getKeyPairs("startTime", RpcRuntimeContext.now())).append(ZookeeperRegistryHelper.getKeyPairs("appName", providerConfig.getAppName()));
                ZookeeperRegistryHelper.addCommonAttrs(sb);
                urls.add(sb.toString());
            }
            return urls;
        }
        return null;
    }

    static String convertConsumerToUrl(ConsumerConfig consumerConfig) {
        StringBuilder sb = new StringBuilder(200);
        String host = SystemInfo.getLocalHost();
        sb.append(consumerConfig.getProtocol()).append("://").append(host).append("?uniqueId=").append(consumerConfig.getUniqueId()).append(ZookeeperRegistryHelper.getKeyPairs("version", "1.0")).append(ZookeeperRegistryHelper.getKeyPairs("pid", RpcRuntimeContext.PID)).append(ZookeeperRegistryHelper.getKeyPairs("timeout", consumerConfig.getTimeout())).append(ZookeeperRegistryHelper.getKeyPairs("id", consumerConfig.getId())).append(ZookeeperRegistryHelper.getKeyPairs("generic", consumerConfig.isGeneric())).append(ZookeeperRegistryHelper.getKeyPairs("appName", consumerConfig.getAppName())).append(ZookeeperRegistryHelper.getKeyPairs("serialization", consumerConfig.getSerialization())).append(ZookeeperRegistryHelper.getKeyPairs("startTime", RpcRuntimeContext.now()));
        ZookeeperRegistryHelper.addCommonAttrs(sb);
        return sb.toString();
    }

    private static String getKeyPairs(String key, Object value) {
        if (value != null) {
            return "&" + key + "=" + value.toString();
        }
        return "";
    }

    private static void addCommonAttrs(StringBuilder sb) {
        sb.append(ZookeeperRegistryHelper.getKeyPairs("pid", RpcRuntimeContext.PID));
        sb.append(ZookeeperRegistryHelper.getKeyPairs("language", "java"));
        sb.append(ZookeeperRegistryHelper.getKeyPairs("rpcVer", "50400"));
    }

    static List<ProviderInfo> convertUrlsToProviders(String providerPath, List<ChildData> currentData) throws UnsupportedEncodingException {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        if (CommonUtils.isEmpty(currentData)) {
            return providerInfos;
        }
        for (ChildData childData : currentData) {
            providerInfos.add(ZookeeperRegistryHelper.convertUrlToProvider(providerPath, childData));
        }
        return providerInfos;
    }

    static ProviderInfo convertUrlToProvider(String providerPath, ChildData childData) throws UnsupportedEncodingException {
        String url = childData.getPath().substring(providerPath.length() + 1);
        url = URLDecoder.decode(url, "UTF-8");
        ProviderInfo providerInfo = ProviderHelper.toProviderInfo(url);
        ZookeeperRegistryHelper.processWarmUpWeight(providerInfo);
        return providerInfo;
    }

    static List<Map<String, String>> convertConfigToAttributes(String configPath, List<ChildData> currentData) {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        if (CommonUtils.isEmpty(currentData)) {
            return attributes;
        }
        for (ChildData childData : currentData) {
            attributes.add(ZookeeperRegistryHelper.convertConfigToAttribute(configPath, childData, false));
        }
        return attributes;
    }

    static Map<String, String> convertConfigToAttribute(String configPath, ChildData childData, boolean removeType) {
        String attribute = childData.getPath().substring(configPath.length() + 1);
        return Collections.singletonMap(attribute, removeType ? RpcConfigs.getStringValue(attribute) : StringSerializer.decode(childData.getData()));
    }

    static List<Map<String, String>> convertOverrideToAttributes(AbstractInterfaceConfig config, String overridePath, List<ChildData> currentData) throws UnsupportedEncodingException {
        ArrayList<Map<String, String>> attributes = new ArrayList<Map<String, String>>();
        if (CommonUtils.isEmpty(currentData)) {
            return attributes;
        }
        for (ChildData childData : currentData) {
            String url = URLDecoder.decode(childData.getPath().substring(overridePath.length() + 1), "UTF-8");
            if (!(config instanceof ConsumerConfig) || !StringUtils.isNotEmpty(url) || !StringUtils.isNotEmpty(SystemInfo.getLocalHost()) || !url.contains("://" + SystemInfo.getLocalHost() + "?")) continue;
            attributes.add(ZookeeperRegistryHelper.convertConfigToAttribute(overridePath, childData, false));
        }
        return attributes;
    }

    static Map<String, String> convertOverrideToAttribute(String overridePath, ChildData childData, boolean removeType, AbstractInterfaceConfig registerConfig) throws Exception {
        String url = URLDecoder.decode(childData.getPath().substring(overridePath.length() + 1), "UTF-8");
        ConcurrentHashMap<String, String> attribute = new ConcurrentHashMap<String, String>();
        for (String keyPairs : url.substring(url.indexOf(63)).split("&")) {
            String[] overrideAttrs = keyPairs.split("=");
            List<String> configKeys = Arrays.asList("timeout", "generic", "appName", "serialization", "dynamic", "weight", "warmupTime", "warmupWeight");
            if (!configKeys.contains(overrideAttrs[0])) continue;
            if (removeType) {
                Method getMethod = ReflectUtils.getPropertyGetterMethod(AbstractInterfaceConfig.class, overrideAttrs[0]);
                Class<?> propertyClazz = getMethod.getReturnType();
                attribute.put(overrideAttrs[0], StringUtils.toString(BeanUtils.getProperty(registerConfig, overrideAttrs[0], propertyClazz)));
                continue;
            }
            attribute.put(overrideAttrs[0], overrideAttrs[1]);
        }
        return attribute;
    }

    static void processWarmUpWeight(ProviderInfo providerInfo) {
        String warmupTimeStr = providerInfo.getStaticAttr("warmupTime");
        String warmupWeightStr = providerInfo.getStaticAttr("warmupWeight");
        String startTimeStr = providerInfo.getStaticAttr("startTime");
        if (StringUtils.isNotBlank(warmupTimeStr) && StringUtils.isNotBlank(warmupWeightStr) && StringUtils.isNotBlank(startTimeStr)) {
            long warmupTime = CommonUtils.parseLong(warmupTimeStr, 0L);
            int warmupWeight = CommonUtils.parseInt(warmupWeightStr, Integer.parseInt(providerInfo.getStaticAttr("weight")));
            long startTime = CommonUtils.parseLong(startTimeStr, 0L);
            long warmupEndTime = startTime + warmupTime;
            providerInfo.setDynamicAttr("warmupWeight", warmupWeight);
            providerInfo.setDynamicAttr("warmupEndTime", warmupEndTime);
            providerInfo.setStatus(ProviderStatus.WARMING_UP);
        }
        providerInfo.getStaticAttrs().remove("warmupTime");
        providerInfo.getStaticAttrs().remove("warmupWeight");
    }

    static String buildProviderPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/providers";
    }

    static String buildConsumerPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/consumers";
    }

    static String buildConfigPath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/configs";
    }

    static String buildOverridePath(String rootPath, AbstractInterfaceConfig config) {
        return rootPath + "sofa-rpc/" + config.getInterfaceId() + "/overrides";
    }

    static List<ProviderInfo> matchProviderInfos(ConsumerConfig consumerConfig, List<ProviderInfo> providerInfos) {
        String protocol = consumerConfig.getProtocol();
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        for (ProviderInfo providerInfo : providerInfos) {
            if (!providerInfo.getProtocolType().equalsIgnoreCase(protocol) || !StringUtils.equals(consumerConfig.getUniqueId(), providerInfo.getAttr("uniqueId"))) continue;
            result.add(providerInfo);
        }
        return result;
    }
}

