/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.server.http.HttpServerHandler;
import com.alipay.sofa.rpc.transport.http.HttpTracerUtils;
import com.alipay.sofa.rpc.transport.http.HttpTransportUtils;
import com.alipay.sofa.rpc.transport.netty.NettyByteBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.HashMap;
import java.util.Map;

public final class Http2ServerChannelHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http2ServerChannelHandler.class);
    private final Http2Connection.PropertyKey headerKey = this.encoder().connection().newKey();
    private final HttpServerHandler serverHandler;

    Http2ServerChannelHandler(HttpServerHandler serverHandler, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
        this.serverHandler = serverHandler;
    }

    private static Http2Headers http1HeadersToHttp2Headers(FullHttpRequest request) {
        String host = request.headers().get((CharSequence)HttpHeaderNames.HOST);
        Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).path((CharSequence)request.uri()).scheme((CharSequence)HttpScheme.HTTP.name());
        if (host != null) {
            http2Headers.authority((CharSequence)host);
        }
        return http2Headers;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            HttpServerUpgradeHandler.UpgradeEvent upgradeEvent = (HttpServerUpgradeHandler.UpgradeEvent)evt;
            this.onHeadersRead(ctx, 1, Http2ServerChannelHandler.http1HeadersToHttp2Headers(upgradeEvent.upgradeRequest()), 0, true);
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("", cause);
        }
        ctx.close();
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        int processed = data.readableBytes() + padding;
        if (endOfStream) {
            Http2Stream http2Stream = this.connection().stream(streamId);
            Http2Headers headers = (Http2Headers)http2Stream.getProperty(this.headerKey);
            this.handleRequest(ctx, streamId, headers, data);
        }
        return processed;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        if (streamId > 1) {
            if (endOfStream) {
                this.handleRequest(ctx, streamId, headers, null);
            } else {
                this.connection().stream(streamId).setProperty(this.headerKey, (Object)headers);
            }
        }
    }

    protected void handleRequest(ChannelHandlerContext ctx, int streamId, Http2Headers http2Headers, ByteBuf data) {
        String uri = StringUtils.defaultString(http2Headers.path());
        if ("/favicon.ico".equals(uri)) {
            this.sendHttp2Response(ctx, streamId, HttpResponseStatus.OK, "");
            return;
        }
        String reqMethod = StringUtils.defaultString(http2Headers.method());
        if (reqMethod.equals(HttpMethod.HEAD.name())) {
            String[] iam = HttpTransportUtils.getInterfaceIdAndMethod(uri);
            boolean exists = this.serverHandler.checkService(iam[0], iam[1]);
            this.sendHttp2Response(ctx, streamId, exists ? HttpResponseStatus.OK : HttpResponseStatus.NOT_FOUND, null);
            return;
        }
        if (!reqMethod.equals(HttpMethod.POST.name())) {
            this.sendHttp2Response(ctx, streamId, HttpResponseStatus.BAD_REQUEST, "Only support POST/HEAD");
            return;
        }
        if (streamId > 1) {
            SofaRequest sofaRequest = new SofaRequest();
            try {
                String[] iam = HttpTransportUtils.getInterfaceIdAndMethod(uri);
                sofaRequest.setTargetServiceUniqueName(iam[0]);
                sofaRequest.setMethodName(iam[1]);
                sofaRequest.setData(new NettyByteBuffer(data));
                this.parseHttp2Request(http2Headers, sofaRequest);
            }
            catch (Exception e) {
                String message = "Failed to parse http2 request for uri " + uri + " form " + NetUtils.channelToString(ctx.channel().remoteAddress(), ctx.channel().localAddress()) + ", cause by: " + e.getMessage();
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(message, e);
                }
                this.sendHttp2Response(ctx, streamId, HttpResponseStatus.BAD_REQUEST, message);
                return;
            }
            try {
                this.serverHandler.handleHttp2Request(streamId, sofaRequest, ctx, this.encoder());
            }
            catch (SofaRpcException e) {
                int type = e.getErrorType();
                if (type == 100) {
                    this.sendHttp2Response(ctx, streamId, HttpResponseStatus.SERVICE_UNAVAILABLE, e.getMessage());
                } else if (type == 110) {
                    this.sendHttp2Response(ctx, streamId, HttpResponseStatus.NOT_FOUND, e.getMessage());
                } else {
                    this.sendHttp2Response(ctx, streamId, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                }
            }
            catch (Exception e) {
                this.sendHttp2Response(ctx, streamId, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            }
        }
    }

    private void parseHttp2Request(Http2Headers headers, SofaRequest sofaRequest) {
        byte serializeType;
        String targetApp = StringUtils.toString(headers.get((Object)"sofa_head_target_app"));
        sofaRequest.setTargetAppName(targetApp);
        CharSequence codeName = (CharSequence)headers.get((Object)"sofa_head_serialize_type");
        if (codeName != null) {
            serializeType = HttpTransportUtils.getSerializeTypeByName(codeName.toString());
        } else {
            String contentType = StringUtils.toString(headers.get((Object)HttpHeaderNames.CONTENT_TYPE));
            serializeType = HttpTransportUtils.getSerializeTypeByContentType(contentType);
        }
        sofaRequest.setSerializeType(serializeType);
        HashMap<String, String> traceMap = new HashMap<String, String>(8);
        for (Map.Entry entry : headers) {
            String key = ((CharSequence)entry.getKey()).toString();
            if (HttpTracerUtils.isTracerKey(key)) {
                HttpTracerUtils.parseTraceKey(traceMap, key, StringUtils.toString(entry.getValue()));
                continue;
            }
            if (key.startsWith(":")) continue;
            sofaRequest.addRequestProp(key, StringUtils.toString(entry.getValue()));
        }
        if (!traceMap.isEmpty()) {
            sofaRequest.addRequestProp("rpc_trace_context", traceMap);
        }
    }

    protected void sendHttp2Response(ChannelHandlerContext ctx, int streamId, HttpResponseStatus status, String result) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)status.codeAsText());
        if (!HttpResponseStatus.OK.equals((Object)status)) {
            headers.set((Object)"sofa_head_response_error", (Object)"true");
        }
        if (StringUtils.isNotBlank(result)) {
            ByteBuf data = ctx.alloc().buffer();
            data.writeBytes(result.getBytes(RpcConstants.DEFAULT_CHARSET));
            this.encoder().writeHeaders(ctx, streamId, headers, 0, false, ctx.newPromise());
            this.encoder().writeData(ctx, streamId, data, 0, true, ctx.newPromise());
        } else {
            this.encoder().writeHeaders(ctx, streamId, headers, 0, true, ctx.newPromise());
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
    }

    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }
}

