/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec;

import com.alipay.sofa.rpc.codec.Compressor;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CompressorFactory {
    private static final ConcurrentMap<Byte, Compressor> TYPE_COMPRESSOR_MAP = new ConcurrentHashMap<Byte, Compressor>();
    private static final ConcurrentMap<String, Byte> TYPE_CODE_MAP = new ConcurrentHashMap<String, Byte>();
    private static final ExtensionLoader<Compressor> EXTENSION_LOADER = CompressorFactory.buildLoader();

    private static ExtensionLoader<Compressor> buildLoader() {
        return ExtensionLoaderFactory.getExtensionLoader(Compressor.class, new ExtensionLoaderListener<Compressor>(){

            @Override
            public void onLoad(ExtensionClass<Compressor> extensionClass) {
                TYPE_COMPRESSOR_MAP.put(extensionClass.getCode(), extensionClass.getExtInstance());
                TYPE_CODE_MAP.put(extensionClass.getAlias(), extensionClass.getCode());
            }
        });
    }

    public static Compressor getCompressor(String alias) {
        return EXTENSION_LOADER.getExtension(alias);
    }

    public static Compressor getCompressor(byte code) {
        Compressor compressor = (Compressor)TYPE_COMPRESSOR_MAP.get(code);
        if (compressor == null) {
            throw new SofaRpcRuntimeException("Compressor Not Found :\"" + code + "\"!");
        }
        return compressor;
    }

    public static byte getCodeByAlias(String compress) {
        return (Byte)TYPE_CODE_MAP.get(compress);
    }
}

