/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.hystrix.FallbackFactory;
import com.alipay.sofa.rpc.hystrix.HystrixResponseFuture;
import com.alipay.sofa.rpc.hystrix.SofaHystrixCommand;
import com.alipay.sofa.rpc.hystrix.SofaHystrixConfig;
import com.alipay.sofa.rpc.hystrix.SofaHystrixInvokable;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.netflix.hystrix.HystrixObservableCommand;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import rx.Observable;
import rx.functions.Func1;

public class SofaHystrixObservableCommand
extends HystrixObservableCommand
implements SofaHystrixInvokable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaHystrixCommand.class);
    private FilterInvoker invoker;
    private SofaRequest request;
    private SofaResponse sofaResponse;
    private ResponseFuture responseFuture;

    public SofaHystrixObservableCommand(FilterInvoker invoker, SofaRequest request) {
        super(SofaHystrixConfig.loadSetterFactory((ConsumerConfig)invoker.getConfig()).createObservableSetter(invoker, request));
        this.invoker = invoker;
        this.request = request;
    }

    protected Observable construct() {
        this.sofaResponse = this.invoker.invoke(this.request);
        this.responseFuture = RpcInternalContext.getContext().getFuture();
        return Observable.from((Future)this.responseFuture);
    }

    protected Observable resumeWithFallback() {
        return Observable.fromCallable((Callable)new Callable<FallbackFactory>(){

            @Override
            public FallbackFactory call() throws Exception {
                return SofaHystrixConfig.loadFallbackFactory((ConsumerConfig)SofaHystrixObservableCommand.this.invoker.getConfig());
            }
        }).flatMap(new Func1<FallbackFactory, Observable<?>>(){

            public Observable<?> call(final FallbackFactory fallbackFactory) {
                if (fallbackFactory != null) {
                    return Observable.fromCallable((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return fallbackFactory.create(null, SofaHystrixObservableCommand.this.getExecutionException());
                        }
                    }).map((Func1)new Func1<Object, Object>(){

                        public Object call(Object fallback) {
                            try {
                                return SofaHystrixObservableCommand.this.request.getMethod().invoke(fallback, SofaHystrixObservableCommand.this.request.getMethodArgs());
                            }
                            catch (IllegalAccessException e) {
                                throw new SofaRpcRuntimeException("Hystrix fallback method failed to execute.", e);
                            }
                            catch (InvocationTargetException e) {
                                throw new SofaRpcRuntimeException("Hystrix fallback method failed to execute.", e.getTargetException());
                            }
                        }
                    });
                }
                return SofaHystrixObservableCommand.super.resumeWithFallback();
            }
        });
    }

    @Override
    public SofaResponse invoke() {
        if (this.isCircuitBreakerOpen() && LOGGER.isWarnEnabled(this.invoker.getConfig().getAppName())) {
            LOGGER.warnWithApp(this.invoker.getConfig().getAppName(), "Circuit Breaker is opened, method: {}#{}", this.invoker.getConfig().getInterfaceId(), this.request.getMethodName());
        }
        Future delegate = this.toObservable().toBlocking().toFuture();
        RpcInternalContext.getContext().setFuture(new HystrixResponseFuture(delegate, this.responseFuture));
        if (this.sofaResponse == null && this.responseFuture == null) {
            return new SofaResponse();
        }
        return this.sofaResponse;
    }
}

