/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.LoadBalancer;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.core.exception.SofaRouteException;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.log.LogCodes;
import java.util.List;

public abstract class AbstractLoadBalancer
extends LoadBalancer {
    public AbstractLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo select(SofaRequest request, List<ProviderInfo> providerInfos) throws SofaRpcException {
        if (providerInfos.size() == 0) {
            throw this.noAvailableProviderException(request.getTargetServiceUniqueName());
        }
        if (providerInfos.size() == 1) {
            return providerInfos.get(0);
        }
        return this.doSelect(request, providerInfos);
    }

    protected SofaRouteException noAvailableProviderException(String serviceKey) {
        return new SofaRouteException(LogCodes.getLog("02306", serviceKey));
    }

    public abstract ProviderInfo doSelect(SofaRequest var1, List<ProviderInfo> var2);

    protected int getWeight(ProviderInfo providerInfo) {
        return providerInfo.getWeight() < 0 ? 0 : providerInfo.getWeight();
    }
}

