/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.hystrix;

import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.hystrix.FallbackContext;
import com.alipay.sofa.rpc.hystrix.FallbackFactory;
import com.alipay.sofa.rpc.hystrix.HystrixResponseFuture;
import com.alipay.sofa.rpc.hystrix.SofaAsyncHystrixEvent;
import com.alipay.sofa.rpc.hystrix.SofaHystrixConfig;
import com.alipay.sofa.rpc.hystrix.SofaHystrixInvokable;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixEventType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SofaAsyncHystrixCommand
extends HystrixCommand
implements SofaHystrixInvokable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaAsyncHystrixCommand.class);
    private static final long DEFAULT_LOCK_TIMEOUT = 1000L;
    private final FilterInvoker invoker;
    private final SofaRequest request;
    private final RpcInternalContext rpcInternalContext;
    private final RpcInvokeContext rpcInvokeContext;
    private final CountDownLatch lock = new CountDownLatch(1);
    private final List<SofaAsyncHystrixEvent> events = new ArrayList<SofaAsyncHystrixEvent>();
    private SofaResponse sofaResponse;

    public SofaAsyncHystrixCommand(FilterInvoker invoker, SofaRequest request) {
        super(SofaHystrixConfig.loadSetterFactory((ConsumerConfig)invoker.getConfig()).createSetter(invoker, request));
        this.rpcInternalContext = RpcInternalContext.peekContext();
        this.rpcInvokeContext = RpcInvokeContext.peekContext();
        this.invoker = invoker;
        this.request = request;
    }

    @Override
    public SofaResponse invoke() {
        if (this.isCircuitBreakerOpen() && LOGGER.isWarnEnabled(this.invoker.getConfig().getAppName())) {
            LOGGER.warnWithApp(this.invoker.getConfig().getAppName(), "Circuit Breaker is opened, method: {}#{}", this.invoker.getConfig().getInterfaceId(), this.request.getMethodName());
        }
        HystrixResponseFuture delegate = new HystrixResponseFuture(this.queue());
        try {
            boolean finished = this.lock.await(this.getLockTimeout(), TimeUnit.MILLISECONDS);
            if (!finished && !this.isExecutionComplete()) {
                throw new SofaTimeOutException("Asynchronous execution timed out, please check Hystrix configuration. Events: " + this.getExecutionEventsString());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        RpcInternalContext.getContext().setFuture(delegate);
        if (this.sofaResponse == null) {
            this.sofaResponse = this.buildEmptyResponse(this.request);
        }
        return this.sofaResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object run() throws Exception {
        this.events.add(SofaAsyncHystrixEvent.EMIT);
        RpcInternalContext.setContext(this.rpcInternalContext);
        RpcInvokeContext.setContext(this.rpcInvokeContext);
        this.sofaResponse = this.invoker.invoke(this.request);
        ResponseFuture responseFuture = RpcInternalContext.getContext().getFuture();
        this.lock.countDown();
        this.events.add(SofaAsyncHystrixEvent.INVOKE_UNLOCKED);
        try {
            Object v = responseFuture.get();
            return v;
        }
        finally {
            this.events.add(SofaAsyncHystrixEvent.INVOKE_SUCCESS);
        }
    }

    protected Object getFallback() {
        FallbackFactory fallbackFactory;
        this.events.add(SofaAsyncHystrixEvent.FALLBACK_EMIT);
        if (this.lock.getCount() > 0L) {
            this.sofaResponse = this.buildEmptyResponse(this.request);
            this.lock.countDown();
            this.events.add(SofaAsyncHystrixEvent.FALLBACK_UNLOCKED);
        }
        if ((fallbackFactory = SofaHystrixConfig.loadFallbackFactory((ConsumerConfig)this.invoker.getConfig())) == null) {
            return super.getFallback();
        }
        Object fallback = fallbackFactory.create(new FallbackContext(this.invoker, this.request, this.sofaResponse, this.getExecutionException()));
        if (fallback == null) {
            return super.getFallback();
        }
        try {
            Object object = this.request.getMethod().invoke(fallback, this.request.getMethodArgs());
            return object;
        }
        catch (IllegalAccessException e) {
            throw new SofaRpcRuntimeException("Hystrix fallback method failed to execute.", e);
        }
        catch (InvocationTargetException e) {
            throw new SofaRpcRuntimeException("Hystrix fallback method failed to execute.", e.getTargetException());
        }
        finally {
            this.events.add(SofaAsyncHystrixEvent.FALLBACK_SUCCESS);
        }
    }

    private SofaResponse buildEmptyResponse(SofaRequest request) {
        SofaResponse response = new SofaResponse();
        Method method = request.getMethod();
        if (method != null) {
            response.setAppResponse(ClassUtils.getDefaultPrimitiveValue(method.getReturnType()));
        }
        return response;
    }

    private long getLockTimeout() {
        if (((Boolean)this.getProperties().executionTimeoutEnabled().get()).booleanValue()) {
            return ((Integer)this.getProperties().executionTimeoutInMilliseconds().get()).intValue();
        }
        return 1000L;
    }

    private String getExecutionEventsString() {
        List<HystrixEventType> executionEvents = this.getExecutionEvents();
        if (executionEvents == null) {
            executionEvents = Collections.emptyList();
        }
        StringBuilder message = new StringBuilder("[");
        for (HystrixEventType executionEvent : executionEvents) {
            message.append(HystrixEventType.class.getSimpleName()).append("#").append(executionEvent.name()).append(",");
        }
        for (SofaAsyncHystrixEvent event : this.events) {
            message.append(SofaAsyncHystrixEvent.class.getSimpleName()).append("#").append(event.name()).append(",");
        }
        if (message.length() > 1) {
            message.deleteCharAt(message.length() - 1);
        }
        return message.append("]").toString();
    }
}

