/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.extensions.log;

import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.extensions.SpanExtension;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import io.opentracing.Span;
import org.slf4j.MDC;

public class MDCSpanExtension
implements SpanExtension {
    public void logStartedSpan(Span currentSpan) {
        SofaTracerSpan span;
        SofaTracerSpanContext sofaTracerSpanContext;
        if (currentSpan != null && (sofaTracerSpanContext = (span = (SofaTracerSpan)currentSpan).getSofaTracerSpanContext()) != null) {
            MDC.put((String)"SOFA-TraceId", (String)sofaTracerSpanContext.getTraceId());
            MDC.put((String)"SOFA-SpanId", (String)sofaTracerSpanContext.getSpanId());
        }
    }

    public void logStoppedSpan(Span currentSpan) {
        SofaTracerSpanContext sofaTracerSpanContext;
        SofaTracerSpan span;
        SofaTracerSpan parentSpan;
        MDC.remove((String)"SOFA-TraceId");
        MDC.remove((String)"SOFA-SpanId");
        if (currentSpan != null && (parentSpan = (span = (SofaTracerSpan)currentSpan).getParentSofaTracerSpan()) != null && (sofaTracerSpanContext = parentSpan.getSofaTracerSpanContext()) != null) {
            MDC.put((String)"SOFA-TraceId", (String)sofaTracerSpanContext.getTraceId());
            MDC.put((String)"SOFA-SpanId", (String)sofaTracerSpanContext.getSpanId());
        }
    }

    public void logStoppedSpanInRunnable(Span currentSpan) {
        MDC.remove((String)"SOFA-TraceId");
        MDC.remove((String)"SOFA-SpanId");
    }

    public String supportName() {
        return "slf4jmdc";
    }
}

