/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation.reactive;

import com.aliyun.apache.hc.core5.http.Header;
import com.aliyun.apache.hc.core5.http.HttpStreamResetException;
import com.aliyun.apache.hc.core5.http.nio.AsyncDataConsumer;
import com.aliyun.apache.hc.core5.http.nio.CapacityChannel;
import com.aliyun.apache.hc.core5.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ReactiveDataConsumer
implements AsyncDataConsumer,
Publisher<ByteBuffer> {
    private final AtomicLong requests = new AtomicLong(0L);
    private final BlockingQueue<ByteBuffer> buffers = new LinkedBlockingQueue<ByteBuffer>();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final Object flushLock = new Object();
    private final AtomicInteger windowScalingIncrement = new AtomicInteger(0);
    private volatile boolean cancelled;
    private volatile boolean completed;
    private volatile Exception exception;
    private volatile CapacityChannel capacityChannel;
    private volatile Subscriber<? super ByteBuffer> subscriber;

    ReactiveDataConsumer() {
    }

    public void failed(Exception cause) {
        if (!this.completed) {
            this.exception = cause;
            this.flushToSubscriber();
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.throwIfCancelled();
        this.capacityChannel = capacityChannel;
        this.signalCapacity(capacityChannel);
    }

    private void signalCapacity(CapacityChannel channel) throws IOException {
        int increment = this.windowScalingIncrement.getAndSet(0);
        if (increment > 0) {
            channel.update(increment);
        }
    }

    private void throwIfCancelled() throws IOException {
        if (this.cancelled) {
            throw new HttpStreamResetException("Downstream subscriber to ReactiveDataConsumer cancelled");
        }
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        if (this.completed) {
            throw new IllegalStateException("Received data past end of stream");
        }
        this.throwIfCancelled();
        byte[] copy = new byte[byteBuffer.remaining()];
        byteBuffer.get(copy);
        this.buffers.add(ByteBuffer.wrap(copy));
        this.flushToSubscriber();
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) {
        this.completed = true;
        this.flushToSubscriber();
    }

    @Override
    public void releaseResources() {
        this.capacityChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushToSubscriber() {
        Object object = this.flushLock;
        synchronized (object) {
            Subscriber<? super ByteBuffer> s = this.subscriber;
            if (this.flushInProgress.getAndSet(true)) {
                return;
            }
            try {
                ByteBuffer next;
                if (s == null) {
                    return;
                }
                if (this.exception != null) {
                    s.onError((Throwable)this.exception);
                    this.subscriber = null;
                    return;
                }
                while (this.requests.get() > 0L && (next = (ByteBuffer)this.buffers.poll()) != null) {
                    int bytesFreed = next.remaining();
                    s.onNext((Object)next);
                    this.requests.decrementAndGet();
                    this.windowScalingIncrement.addAndGet(bytesFreed);
                }
                CapacityChannel localChannel = this.capacityChannel;
                if (localChannel != null) {
                    try {
                        this.signalCapacity(localChannel);
                    }
                    catch (IOException e) {
                        this.exception = e;
                        s.onError((Throwable)e);
                        this.flushInProgress.set(false);
                        return;
                    }
                }
                if (!this.completed) return;
                if (!this.buffers.isEmpty()) return;
                s.onComplete();
                this.subscriber = null;
            }
            finally {
                this.flushInProgress.set(false);
            }
            return;
        }
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.subscriber = Args.notNull(subscriber, "subscriber");
        subscriber.onSubscribe(new Subscription(){

            public void request(long increment) {
                if (increment <= 0L) {
                    ReactiveDataConsumer.this.failed(new IllegalArgumentException("The number of elements requested must be strictly positive"));
                    return;
                }
                ReactiveDataConsumer.this.requests.addAndGet(increment);
                ReactiveDataConsumer.this.flushToSubscriber();
            }

            public void cancel() {
                ReactiveDataConsumer.this.cancelled = true;
                ReactiveDataConsumer.this.subscriber = null;
            }
        });
    }
}

