package com.aliyun.core.utils;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.*;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class BaseUtils {
    private static final String COMMA = ",";
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([\\S]+)\\b", Pattern.CASE_INSENSITIVE);

    private BaseUtils() {
        // Exists only to defeat instantiation.
    }

    public static byte[] clone(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static int[] clone(int[] source) {
        if (source == null) {
            return null;
        }
        int[] copy = new int[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static <T> T[] clone(T[] source) {
        if (source == null) {
            return null;
        }

        return Arrays.copyOf(source, source.length);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> String arrayToString(T[] array, Function<T, String> mapper) {
        if (isNullOrEmpty(array)) {
            return null;
        }

        return Arrays.stream(array).map(mapper).collect(Collectors.joining(COMMA));
    }

    public static <T> T findFirstOfType(Object[] args, Class<T> clazz) {
        if (isNullOrEmpty(args)) {
            return null;
        }

        for (Object arg : args) {
            if (clazz.isInstance(arg)) {
                return clazz.cast(arg);
            }
        }

        return null;
    }

    public static String bomAwareToString(byte[] bytes, String contentType) {
        if (bytes == null) {
            return null;
        }

        /*
         * Attempt to retrieve the default charset from the 'Content-Encoding' header, if the value isn't
         * present or invalid fallback to 'UTF-8' for the default charset.
         */
        if (!StringUtils.isEmpty(contentType)) {
            try {
                Matcher charsetMatcher = CHARSET_PATTERN.matcher(contentType);
                if (charsetMatcher.find()) {
                    return new String(bytes, Charset.forName(charsetMatcher.group(1)));
                } else {
                    return new String(bytes, StandardCharsets.UTF_8);
                }
            } catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
        } else {
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }
}
