/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.BasicSessionCredentials;
import com.aliyuncs.auth.KeyPairCredentials;
import com.aliyuncs.auth.sts.GenerateSessionAccessKeyResponse;
import com.aliyuncs.auth.sts.GetSessionAccessKeyRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.IClientProfile;

public class STSGetSessionAccessKeyCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final IAcsClient stsClient;
    private final KeyPairCredentials keyPairCredentials;
    private long sessionDurationSeconds = 3600L;
    private BasicSessionCredentials sessionCredentials = null;

    public STSGetSessionAccessKeyCredentialsProvider(KeyPairCredentials keyPairCredentials, IClientProfile profile) {
        this.keyPairCredentials = keyPairCredentials;
        this.stsClient = new DefaultAcsClient(profile, keyPairCredentials);
    }

    public STSGetSessionAccessKeyCredentialsProvider withDurationSeconds(long seconds) {
        this.sessionDurationSeconds = seconds;
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.sessionCredentials == null || this.sessionCredentials.willSoonExpire()) {
            this.sessionCredentials = this.getNewSessionCredentials();
        }
        return this.sessionCredentials;
    }

    private BasicSessionCredentials getNewSessionCredentials() throws ClientException, ServerException {
        GetSessionAccessKeyRequest request = new GetSessionAccessKeyRequest();
        request.setPublicKeyId(this.keyPairCredentials.getAccessKeyId());
        request.setDurationSeconds((int)this.sessionDurationSeconds);
        request.setProtocol(ProtocolType.HTTPS);
        GenerateSessionAccessKeyResponse response = this.stsClient.getAcsResponse(request);
        return new BasicSessionCredentials(response.getSessionAccessKey().getSessionAccessKeyId(), response.getSessionAccessKey().getSessionAccessKeySecert(), null, this.sessionDurationSeconds);
    }
}

