/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapUtils {
    public static String getMapString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    public Map<Object, Object> convertMapToMap(Map<String, String> flattenMap, String prefix) {
        Object obj = new HashMap();
        obj = this.parse(obj, flattenMap, prefix);
        return (Map)obj;
    }

    public List<Map<Object, Object>> convertMapToListMap(Map<String, String> flattenMap, String prefix) {
        Object obj = new ArrayList();
        obj = this.parse(obj, flattenMap, prefix);
        return (List)obj;
    }

    private Object parse(Object objSource, Map<String, String> flattenMap, String prefix) {
        Object obj = objSource;
        for (Map.Entry<String, String> entry : flattenMap.entrySet()) {
            String remainKey;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.indexOf(prefix) != 0 || (remainKey = key.replace(prefix, "")).toLowerCase().endsWith(".length") || remainKey.indexOf("[") != 0 && remainKey.indexOf(".") != 0) continue;
            obj = this.resolve(obj, remainKey, value);
        }
        return obj;
    }

    private Object resolve(Object objSource, String currKey, String value) {
        Object obj = objSource;
        if (currKey.equalsIgnoreCase("length") || currKey.equalsIgnoreCase(".length")) {
            return obj;
        }
        String key = this.popKey(currKey);
        String remainKey = this.popRemainKey(currKey);
        if (remainKey.equalsIgnoreCase("length") || remainKey.equalsIgnoreCase(".length")) {
            Map currMap = this.initMap(obj, key);
            int len = Integer.parseInt(value);
            List currList = this.initList(currMap.get(key), len);
            currMap.put(key, currList);
            obj = currMap;
            return obj;
        }
        if (remainKey.length() == 0) {
            if (key.contains("[")) {
                int index = this.getIndexFromKey(key);
                List currList = this.initList(obj, index);
                currList.set(index, value);
                obj = currList;
            } else {
                Map currMap = this.initMap(obj, key);
                currMap.put(key, value);
                obj = currMap;
            }
            return obj;
        }
        if (key.contains("[")) {
            int index = this.getIndexFromKey(key);
            List currList = this.initList(obj, index);
            Object newObj = currList.get(index);
            currList.set(index, this.resolve(newObj, remainKey, value));
            obj = currList;
        } else {
            Map currMap = this.initMap(obj, key);
            currMap.put(key, this.resolve(currMap.get(key), remainKey, value));
            obj = currMap;
        }
        return obj;
    }

    private Map initMap(Object obj, String key) {
        HashMap<String, Object> currMap = (HashMap<String, Object>)obj;
        if (null == currMap) {
            currMap = new HashMap<String, Object>();
        }
        if (!currMap.containsKey(key)) {
            currMap.put(key, null);
        }
        return currMap;
    }

    private List initList(Object obj, int index) {
        ArrayList<Object> currList = (ArrayList<Object>)obj;
        if (null == currList) {
            currList = new ArrayList<Object>();
        }
        while (currList.size() <= index) {
            currList.add(null);
        }
        return currList;
    }

    private int getIndexFromKey(String key) {
        return Integer.parseInt(key.replace("[", "").replace("]", ""));
    }

    private String getMapKeyFromListIndex(String key) {
        return key.substring(0, key.indexOf("["));
    }

    private String popKey(String keyString) {
        String[] keys;
        String key = keyString;
        if (key.startsWith(".")) {
            key = key.substring(1);
        }
        if ((key = (keys = key.split("\\."))[0]).contains("[") && key.indexOf("[") != 0) {
            return this.getMapKeyFromListIndex(key);
        }
        return key;
    }

    private String popRemainKey(String keyString) {
        String popKey;
        String key = keyString;
        if (key.startsWith(".")) {
            key = key.substring(1);
        }
        if ((popKey = this.popKey(key)).endsWith("Length")) {
            return "";
        }
        String remainKey = key.substring(popKey.length());
        if (remainKey.startsWith(".")) {
            remainKey = remainKey.substring(1);
        }
        return remainKey;
    }
}

