/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsError;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.AnonymousCredentials;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.DefaultCredentialsProvider;
import com.aliyuncs.auth.LegacyCredentials;
import com.aliyuncs.auth.SignatureVersion;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.auth.signers.SignatureAlgorithm;
import com.aliyuncs.endpoint.DefaultEndpointResolver;
import com.aliyuncs.endpoint.EndpointResolver;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.exceptions.ThrottlingException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpClientFactory;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.HttpUtil;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.http.UserAgentConfig;
import com.aliyuncs.http.X509TrustAll;
import com.aliyuncs.policy.retry.RetryPolicy;
import com.aliyuncs.policy.retry.RetryPolicyContext;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import com.aliyuncs.unmarshaller.Unmarshaller;
import com.aliyuncs.unmarshaller.UnmarshallerFactory;
import com.aliyuncs.utils.HttpHeadersInjectAdapter;
import com.aliyuncs.utils.IOUtils;
import com.aliyuncs.utils.LogUtils;
import com.aliyuncs.utils.MapUtils;
import com.aliyuncs.utils.TraceUtils;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;

public class DefaultAcsClient
implements IAcsClient {
    private int maxRetryNumber = 3;
    private boolean autoRetry = true;
    private IClientProfile clientProfile = null;
    private AlibabaCloudCredentialsProvider credentialsProvider;
    private IHttpClient httpClient;
    private EndpointResolver endpointResolver;
    private static final String SIGNATURE_BEGIN = "string to sign is:";
    private final UserAgentConfig userAgentConfig = new UserAgentConfig();
    private SignatureVersion signatureVersion = SignatureVersion.V1;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.ACS3_HMAC_SHA256;
    private final String SEPARATOR = "::";
    private RetryPolicy retryPolicy = RetryPolicy.none();

    @Deprecated
    public DefaultAcsClient() throws ClientException {
        this.clientProfile = DefaultProfile.getProfile();
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
    }

    public DefaultAcsClient(String regionId) throws ClientException {
        this.clientProfile = DefaultProfile.getProfile(regionId);
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
        this.credentialsProvider = new DefaultCredentialsProvider();
        this.endpointResolver = new DefaultEndpointResolver(this);
        this.appendUserAgent("HTTPClient", this.httpClient.getClass().getSimpleName());
    }

    public DefaultAcsClient(IClientProfile profile) {
        this(profile, new StaticCredentialsProvider(profile));
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials) {
        this(profile, new StaticCredentialsProvider(credentials));
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider) {
        this.clientProfile = profile;
        this.credentialsProvider = credentialsProvider;
        this.clientProfile.setCredentialsProvider(this.credentialsProvider);
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
        this.endpointResolver = new DefaultEndpointResolver(this, profile);
        this.appendUserAgent("HTTPClient", this.httpClient.getClass().getSimpleName());
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryCounts, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, IClientProfile profile) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, profile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, String regionId, Credential credential) throws ClientException, ServerException {
        if (null == request.getSysSignatureVersion()) {
            request.setSysSignatureVersion(this.signatureVersion);
        }
        if (null == request.getSysSignatureAlgorithm()) {
            request.setSysSignatureAlgorithm(this.signatureAlgorithm);
        }
        Signer signer = Signer.getSigner(new LegacyCredentials(credential), request.getSysSignatureVersion(), request.getSysSignatureAlgorithm());
        FormatType format = null;
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(regionId);
        }
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, regionId, new LegacyCredentials(credential), signer, format);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, autoRetry, maxRetryCounts);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, IClientProfile profile) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, profile);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId, Credential credential) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, regionId, credential);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId) throws ServerException, ClientException {
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(regionId);
        }
        HttpResponse baseResponse = this.doAction(request);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public CommonResponse getCommonResponse(CommonRequest request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request.buildRequest());
        if (baseResponse.isSuccess()) {
            String stringContent = baseResponse.getHttpContentString();
            CommonResponse response = new CommonResponse();
            response.setData(stringContent);
            response.setHttpStatus(baseResponse.getStatus());
            response.setHttpResponse(baseResponse);
            return response;
        }
        FormatType format = baseResponse.getHttpContentType();
        AcsError error = this.readError(baseResponse, format);
        if (500 <= baseResponse.getStatus()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts, IClientProfile profile) throws ClientException, ServerException {
        if (null == profile) {
            throw new ClientException("SDK.InvalidProfile", "No active profile found.");
        }
        boolean retry = autoRetry;
        int retryNumber = maxRetryCounts;
        String region = profile.getRegionId();
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(region);
        }
        AlibabaCloudCredentials credentials = null == this.credentialsProvider ? new AnonymousCredentials() : this.credentialsProvider.getCredentials();
        if (null == request.getSysSignatureVersion()) {
            request.setSysSignatureVersion(this.signatureVersion);
        }
        if (null == request.getSysSignatureAlgorithm()) {
            request.setSysSignatureAlgorithm(this.signatureAlgorithm);
        }
        Signer signer = Signer.getSigner(credentials, request.getSysSignatureVersion(), request.getSysSignatureAlgorithm());
        FormatType format = profile.getFormat();
        return this.doAction(request, retry, retryNumber, request.getSysRegionId(), credentials, signer, format);
    }

    private <T extends AcsResponse> T parseAcsResponse(AcsRequest<T> request, HttpResponse baseResponse) throws ServerException, ClientException {
        FormatType format = baseResponse.getHttpContentType();
        if (FormatType.JSON != format && FormatType.XML != format) {
            throw new ClientException(String.format("Server response has a bad format type: %s;\nThe original return is: %s;\nThe original header is: %s;", new Object[]{format, baseResponse.getHttpContentString(), baseResponse.getSysHeaders().toString()}));
        }
        if (baseResponse.isSuccess()) {
            return this.readResponse(request.getResponseClass(), baseResponse, format);
        }
        AcsError error = this.readError(baseResponse, format);
        if (500 <= baseResponse.getStatus()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        if (400 == baseResponse.getStatus() && ("IncompleteSignature".equals(error.getErrorCode()) || "SignatureDoesNotMatch".equals(error.getErrorCode()))) {
            int start;
            String errorStrToSign;
            String errorMessage = error.getErrorMessage();
            Pattern startPattern = Pattern.compile(SIGNATURE_BEGIN);
            Matcher startMatcher = startPattern.matcher(errorMessage);
            if (startMatcher.find() && request.strToSign.equals(errorStrToSign = errorMessage.substring(start = startMatcher.end()))) {
                throw new ClientException("SDK.InvalidAccessKeySecret", "Specified Access Key Secret is not valid.", error.getRequestId());
            }
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId(), error.getErrorDescription());
    }

    @Deprecated
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, Credential credential, Signer signer, FormatType format) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryNumber, regionId, new LegacyCredentials(credential), signer, format);
    }

    public ProductDomain getDomain(AcsRequest request, String regionId) throws ClientException {
        ProductDomain domain = null;
        if (request.getSysProductDomain() != null) {
            domain = request.getSysProductDomain();
        } else {
            ResolveEndpointRequest resolveEndpointRequest = new ResolveEndpointRequest(regionId, request.getSysProduct(), request.getSysLocationProduct(), request.getSysEndpointType());
            resolveEndpointRequest.setProductEndpointMap(request.productEndpointMap);
            resolveEndpointRequest.setProductEndpointRegional(request.productEndpointRegional);
            resolveEndpointRequest.setProductNetwork(request.productNetwork);
            resolveEndpointRequest.setProductSuffix(request.productSuffix);
            String endpoint = this.endpointResolver.resolve(resolveEndpointRequest);
            domain = new ProductDomain(request.getSysProduct(), endpoint);
            if (endpoint.endsWith("endpoint-test.exception.com")) {
                throw new ClientException("SDK.EndpointTestability", endpoint);
            }
        }
        return domain;
    }

    private <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, AlibabaCloudCredentials credentials, Signer signer, FormatType format) throws ClientException, ServerException {
        if (!GlobalTracer.isRegistered() || this.clientProfile.isCloseTrace()) {
            return this.doRealAction(request, autoRetry, maxRetryNumber, regionId, credentials, signer, format);
        }
        Tracer tracer = GlobalTracer.get();
        Span activeSpan = tracer.activeSpan();
        Tracer.SpanBuilder sb = tracer.buildSpan(request.getSysUrl());
        if (activeSpan != null) {
            sb.asChildOf(activeSpan);
        }
        Span span = sb.withTag(Tags.COMPONENT.getKey(), "aliyunApi").withTag("actionName", request.getSysActionName()).withTag("queryParam", MapUtils.getMapString(request.getQueryParameters())).start();
        tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersInjectAdapter(request));
        try {
            HttpResponse response = this.doRealAction(request, autoRetry, maxRetryNumber, regionId, credentials, signer, format);
            span.setTag("status", (Number)response.getStatus());
            span.setTag("ReasonPhrase", response.getReasonPhrase());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (ClientException ex) {
            TraceUtils.onError(ex, span);
            throw ex;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends AcsResponse> HttpResponse doRealAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, AlibabaCloudCredentials credentials, Signer signer, FormatType format) throws ClientException, ServerException {
        block32: {
            block31: {
                block30: {
                    this.doActionWithProxy(request.getSysProtocol(), System.getenv("HTTPS_PROXY"), System.getenv("HTTP_PROXY"));
                    this.doActionWithIgnoreSSL(request, X509TrustAll.ignoreSSLCerts);
                    logger = this.clientProfile.getLogger();
                    startTime = "";
                    timeCost = "";
                    response = null;
                    errorMessage = "";
                    try {
                        requestFormatType = request.getSysAcceptFormat();
                        if (null != requestFormatType) {
                            format = requestFormatType;
                        }
                        domain = this.getDomain(request, regionId);
                        if (request.getSysProtocol() == null) {
                            request.setSysProtocol(this.clientProfile.getHttpClientConfig().getProtocolType());
                        }
                        request.putHeaderParameter("User-Agent", UserAgentConfig.resolve(request.getSysUserAgentConfig(), this.userAgentConfig));
                        request.putHeaderParameter("x-acs-version", request.getSysVersion());
                        if (null != request.getSysActionName()) {
                            request.putHeaderParameter("x-acs-action", request.getSysActionName());
                        }
                        v0 = coordinate = credentials.getAccessKeyId() == null ? "" : credentials.getAccessKeyId() + "::" + request.getSysProduct() + "::" + request.getSysVersion() + "::" + request.getSysActionName() + "::" + request.getSysRegionId();
                        retryPolicy = request.getSysRetryPolicy() != null ? request.getSysRetryPolicy() : (this.retryPolicy != null ? this.retryPolicy : RetryPolicy.none());
                        retriesAttempted = 0;
                        context = RetryPolicyContext.builder().coordinate(coordinate).retriesAttempted(retriesAttempted).build();
lbl23:
                        // 2 sources

                        while (retryPolicy.shouldRetry(context).booleanValue()) {
                            TimeUnit.MILLISECONDS.sleep(retryPolicy.getBackoffDelay(context));
                            httpRequest = request.signRequest(signer, credentials, format, domain);
                            try {
                                HttpUtil.debugHttpRequest(httpRequest);
                                startTime = LogUtils.localeNow();
                                start = System.nanoTime();
                                response = this.httpClient.syncInvoke(httpRequest);
                                end = System.nanoTime();
                                timeCost = TimeUnit.NANOSECONDS.toMillis(end - start) + "ms";
                                HttpUtil.debugHttpResponse(response);
                                if (response.isSuccess()) {
                                    var25_32 = response;
                                    if (null == logger) return var25_32;
                                    break block30;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (SocketTimeoutException exp) {
                                ex /* !! */  = exp;
                                break block31;
                            }
                            catch (IOException exp) {
                                ex /* !! */  = exp;
                                break block31;
                            }
                        }
                        break block32;
                    }
                    catch (InterruptedException exp) {
                        errorMessage = exp.getMessage();
                        throw new ClientException("SDK.InterruptedException", "Client has been interrupted: connection " + request.getSysUrl() + " failed", exp);
                    }
                    catch (InvalidKeyException exp) {
                        errorMessage = exp.getMessage();
                        throw new ClientException("SDK.InvalidAccessSecret", "Specified access secret is not valid.", exp);
                    }
                    catch (NoSuchAlgorithmException exp) {
                        errorMessage = exp.getMessage();
                        throw new ClientException("SDK.InvalidMD5Algorithm", "MD5 hash is not supported by client side.", exp);
                    }
                    catch (UnsupportedEncodingException exp) {
                        errorMessage = exp.getMessage();
                        throw new ClientException("SDK.UnsupportedEncodingException", "UTF-8 encoding is not supported by client side.", exp);
                    }
                    catch (Throwable exp) {
                        errorMessage = exp.getMessage();
                        if (SocketTimeoutException.class.isAssignableFrom(exp.getClass())) {
                            throw new ClientException("SDK.ReadTimeout", "SocketTimeoutException has occurred on a socket read or accept.The url is " + request.getSysUrl(), exp);
                        }
                        if (IOException.class.isAssignableFrom(exp.getClass())) {
                            throw new ClientException("SDK.ServerUnreachable", "Server unreachable: connection " + request.getSysUrl() + " failed", exp);
                        }
                        if (ServerException.class.isAssignableFrom(exp.getClass())) {
                            throw (ServerException)exp;
                        }
                        if (ThrottlingException.class.isAssignableFrom(exp.getClass())) {
                            throw new ClientException("SDK.RequestTryOrRetryFailed", errorMessage, exp);
                        }
                        if (ClientException.class.isAssignableFrom(exp.getClass()) == false) throw new ClientException("SDK.RequestTryOrRetryFailed", "Some errors occurred. Error message for latest request is " + exp.getMessage(), exp);
                        throw (ClientException)exp;
                    }
                    catch (Throwable var28_36) {
                        if (null == logger) throw var28_36;
                        try {
                            logUnit = LogUtils.createLogUnit(request, response);
                            logUnit.setStartTime(startTime);
                            logUnit.setCost(timeCost);
                            logUnit.setError(errorMessage);
                            logContent = LogUtils.fillContent(this.clientProfile.getLogFormat(), logUnit);
                            logger.info(logContent);
                            throw var28_36;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        throw var28_36;
                    }
                }
                try {
                    logUnit = LogUtils.createLogUnit(request, response);
                    logUnit.setStartTime(startTime);
                    logUnit.setCost(timeCost);
                    logUnit.setError(errorMessage);
                    logContent = LogUtils.fillContent(this.clientProfile.getLogFormat(), logUnit);
                    logger.info(logContent);
                    return var25_32;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return var25_32;
lbl-1000:
                // 1 sources

                {
                    responseFormat = response.getHttpContentType();
                    error = this.readError(response, responseFormat);
                    ex /* !! */  = 500 <= response.getStatus() ? new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId()) : new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
                }
            }
            context = RetryPolicyContext.builder().coordinate(coordinate).retriesAttempted(++retriesAttempted).httpResponse(response).exception(ex /* !! */ ).build();
            ** GOTO lbl23
        }
        if (context.httpResponse() == null) ** GOTO lbl-1000
        var19_24 = context.httpResponse();
        if (null == logger) return var19_24;
        try {
            logUnit = LogUtils.createLogUnit(request, response);
            logUnit.setStartTime(startTime);
            logUnit.setCost(timeCost);
            logUnit.setError(errorMessage);
            logContent = LogUtils.fillContent(this.clientProfile.getLogFormat(), logUnit);
            logger.info(logContent);
            return var19_24;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return var19_24;
lbl-1000:
        // 1 sources

        {
            if (context.exception() != null) {
                throw context.exception();
            }
            errorMessage = "Some errors occurred. Maybe the client triggered throttling policy.";
            throw new ClientException("SDK.RequestTryOrRetryFailed", errorMessage, context.exception());
        }
    }

    protected <T extends AcsResponse> T readResponse(Class<T> clasz, HttpResponse httpResponse, FormatType format) throws ClientException {
        if (clasz.isAnnotationPresent(XmlRootElement.class) && !this.clientProfile.getHttpClientConfig().isCompatibleMode()) {
            Unmarshaller unmarshaller = UnmarshallerFactory.getUnmarshaller(format);
            return unmarshaller.unmarshal(clasz, httpResponse.getHttpContentString());
        }
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        AcsResponse response = null;
        String stringContent = httpResponse.getHttpContentString();
        if (stringContent == null) {
            throw new ClientException("SDK.InvalidServerResponse", "Failed to parse the response. The request was succeeded, but the server returned an empty HTTP body.");
        }
        try {
            response = (AcsResponse)clasz.newInstance();
        }
        catch (Exception e) {
            throw new ClientException("SDK.InvalidResponseClass", "Unable to allocate " + clasz.getName() + " class");
        }
        String responseEndpoint = clasz.getName().substring(clasz.getName().lastIndexOf(".") + 1);
        if (response.checkShowJsonItemName()) {
            context.setResponseMap(reader.read(stringContent, responseEndpoint));
        } else {
            context.setResponseMap(reader.readForHideArrayItem(stringContent, responseEndpoint));
        }
        context.setHttpResponse(httpResponse);
        response.getInstance(context);
        return (T)response;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String stringContent = httpResponse.getHttpContentString();
        if (stringContent == null) {
            error.setErrorCode("(null)");
            error.setErrorMessage("(null)");
            error.setRequestId("(null)");
            error.setStatusCode(httpResponse.getStatus());
            return error;
        }
        try {
            String responseEndpoint = "Error";
            Reader reader = ReaderFactory.createInstance(format);
            UnmarshallerContext context = new UnmarshallerContext();
            context.setResponseMap(reader.read(stringContent, responseEndpoint));
            return error.getInstance(context);
        }
        catch (Exception e) {
            stringContent = "Server response has a bad format type: " + (Object)((Object)format) + ";\nThe original return is: \n" + stringContent;
            error.setErrorCode("(null)");
            error.setErrorMessage(stringContent);
            error.setRequestId("(null)");
            error.setStatusCode(httpResponse.getStatus());
            return error;
        }
    }

    public void doActionWithProxy(ProtocolType protocolType, String httpsProxy, String httpProxy) {
        HttpClientConfig config = this.clientProfile.getHttpClientConfig();
        if (protocolType == ProtocolType.HTTP && httpProxy != null) {
            config.setHttpProxy(httpProxy);
            return;
        }
        if (protocolType == ProtocolType.HTTPS && httpsProxy != null) {
            config.setHttpsProxy(httpsProxy);
            return;
        }
    }

    public void doActionWithIgnoreSSL(AcsRequest request, boolean isIgnore) {
        if (isIgnore) {
            request.setIgnoreSSLCerts(true);
        }
    }

    @Deprecated
    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    @Deprecated
    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    @Deprecated
    public int getMaxRetryNumber() {
        return this.maxRetryNumber;
    }

    @Deprecated
    public void setMaxRetryNumber(int maxRetryNumber) {
        this.maxRetryNumber = maxRetryNumber;
    }

    @Override
    public void restoreSSLCertificate() {
        this.httpClient.restoreSSLCertificate();
    }

    @Override
    public void ignoreSSLCertificate() {
        this.httpClient.ignoreSSLCertificate();
    }

    public void setEndpointResolver(EndpointResolver resolver) {
        this.endpointResolver = resolver;
    }

    @Override
    public void shutdown() {
        if (!this.httpClient.isSingleton()) {
            IOUtils.closeQuietly(this.httpClient);
            this.httpClient = null;
        }
    }

    public DefaultProfile getProfile() {
        return (DefaultProfile)this.clientProfile;
    }

    public void appendUserAgent(String key, String value) {
        this.userAgentConfig.append(key, value);
    }

    public UserAgentConfig getUserAgentConfig() {
        return this.userAgentConfig;
    }

    public IHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(IHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public AlibabaCloudCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public SignatureVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    @Override
    public void setSignatureVersion(SignatureVersion signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public RetryPolicy getSysRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public void setSysRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }
}

