/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth.signers;

import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.Signer;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.xml.bind.DatatypeConverter;

public class NewSHA256withRSASigner
extends Signer {
    public static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "SHA256withRSA";
    private static String HASH_SHA256 = "SHA-256";
    private static final String PEM_BEGIN = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final String PEM_END = "\n-----END RSA PRIVATE KEY-----";

    @Override
    public String signString(String stringToSign, String accessKeySecret) {
        try {
            Signature rsaSign = Signature.getInstance(ALGORITHM_NAME);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] keySpec = DatatypeConverter.parseBase64Binary((String)this.checkRSASecret(accessKeySecret));
            PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(keySpec));
            rsaSign.initSign(privateKey);
            rsaSign.update(stringToSign.getBytes(ENCODING));
            byte[] sign = rsaSign.sign();
            return AcsURLEncoder.hexEncode(sign);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (SignatureException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private String checkRSASecret(String accessKeySecret) {
        if (accessKeySecret != null) {
            if (accessKeySecret.startsWith(PEM_BEGIN)) {
                accessKeySecret = accessKeySecret.replace(PEM_BEGIN, "");
            }
            while (accessKeySecret.endsWith("\n") || accessKeySecret.endsWith("\r")) {
                accessKeySecret = accessKeySecret.substring(0, accessKeySecret.length() - 1);
            }
            if (accessKeySecret.endsWith(PEM_END)) {
                accessKeySecret = accessKeySecret.replace(PEM_END, "");
            }
        }
        return accessKeySecret;
    }

    @Override
    public String signString(String stringToSign, AlibabaCloudCredentials credentials) {
        return this.signString(stringToSign, credentials.getAccessKeySecret());
    }

    @Override
    public String getSignerName() {
        return "ACS3-RSA-SHA256";
    }

    @Override
    public String getSignerVersion() {
        return "3.0";
    }

    @Override
    public String getSignerType() {
        return null;
    }

    @Override
    public byte[] hash(byte[] raw) throws NoSuchAlgorithmException {
        if (null == raw) {
            return null;
        }
        MessageDigest digest = MessageDigest.getInstance(HASH_SHA256);
        return digest.digest(raw);
    }

    @Override
    public String getContent() {
        return "x-acs-content-sha256";
    }
}

