/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AcsURLEncoder;
import com.aliyuncs.auth.ISignatureComposer;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.utils.ParameterHelper;
import com.aliyuncs.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class V3SignatureComposer
implements ISignatureComposer {
    protected static final String QUERY_SEPARATOR = "&";
    protected static final String HEADER_SEPARATOR = "\n";
    private static final String DELIMITER = ";";
    private static ISignatureComposer composer = null;
    private static final String SIGNED_HEADERS = "signedHeaders";
    private static final String CANONICAL_HEADERS = "canonicalHeaders";
    private static final String prefix = "x-acs-";
    private static final String CONTENT_TYPE = "content-type";
    private static final String HOST = "host";

    public static ISignatureComposer getComposer() {
        if (null == composer) {
            composer = new V3SignatureComposer();
        }
        return composer;
    }

    public static String replaceOccupiedParameters(String url, Map<String, String> paths) {
        if (null == paths || paths.isEmpty()) {
            return url;
        }
        String result = url;
        for (Map.Entry<String, String> entry : paths.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String target = "[" + key + "]";
            result = result.replace(target, value);
        }
        return result;
    }

    @Override
    public Map<String, String> refreshSignParameters(Map<String, String> parameters, Signer signer, String accessKeyId, FormatType format) {
        HashMap<String, String> immutableMap = new HashMap<String, String>(parameters);
        immutableMap.put("x-acs-date", ParameterHelper.getISO8601Time(new Date()));
        immutableMap.put("x-acs-signature-nonce", ParameterHelper.getUniqueNonce());
        return immutableMap;
    }

    private Map<String, String> getCanonicalizedHeadersMap(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Object[] keys = headers.keySet().toArray(new String[headers.size()]);
        Arrays.sort(keys);
        ArrayList<String> canonicalizedKeys = new ArrayList<String>();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (Object key : keys) {
            String lowerKey = ((String)key).toLowerCase();
            if (!lowerKey.startsWith(prefix) && !lowerKey.equals(HOST) && !lowerKey.equals(CONTENT_TYPE)) continue;
            if (!canonicalizedKeys.contains(lowerKey)) {
                canonicalizedKeys.add(lowerKey);
            }
            valueMap.put(lowerKey, !StringUtils.isEmpty(headers.get(key)) ? headers.get(key).trim() : null);
        }
        String[] canonicalizedKeysArray = canonicalizedKeys.toArray(new String[canonicalizedKeys.size()]);
        String signedHeaders = StringUtils.join(DELIMITER, Arrays.asList(canonicalizedKeysArray));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < canonicalizedKeysArray.length; ++i) {
            String key = canonicalizedKeysArray[i];
            sb.append(key);
            sb.append(":");
            sb.append((String)valueMap.get(key));
            sb.append(HEADER_SEPARATOR);
        }
        result.put(CANONICAL_HEADERS, sb.toString());
        result.put(SIGNED_HEADERS, signedHeaders);
        return result;
    }

    private String getCanonicalizedResource(Map<String, String> query) {
        if (query == null || query.size() == 0) {
            return "";
        }
        Object[] keys = query.keySet().toArray(new String[query.size()]);
        Arrays.sort(keys);
        StringBuilder queryString = new StringBuilder();
        try {
            for (int i = 0; i < keys.length; ++i) {
                queryString.append(AcsURLEncoder.percentEncode((String)keys[i]));
                queryString.append("=");
                if (!StringUtils.isEmpty(query.get(keys[i]))) {
                    queryString.append(AcsURLEncoder.percentEncode(query.get(keys[i])));
                }
                queryString.append(QUERY_SEPARATOR);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.toString());
        }
        return queryString.length() > 0 ? queryString.deleteCharAt(queryString.length() - 1).toString() : "";
    }

    @Override
    public String composeStringToSign(MethodType method, String uriPattern, Signer signer, Map<String, String> queries, Map<String, String> headers, Map<String, String> paths) {
        String canonicalURI = V3SignatureComposer.replaceOccupiedParameters(uriPattern, paths);
        if (StringUtils.isEmpty(canonicalURI)) {
            canonicalURI = "/";
        }
        Map<String, String> cannoicalHeaders = this.getCanonicalizedHeadersMap(headers);
        String queryString = this.getCanonicalizedResource(queries);
        StringBuilder sb = new StringBuilder(String.valueOf((Object)method));
        sb.append(HEADER_SEPARATOR).append(canonicalURI).append(HEADER_SEPARATOR).append(queryString).append(HEADER_SEPARATOR).append(cannoicalHeaders.get(CANONICAL_HEADERS)).append(HEADER_SEPARATOR).append(cannoicalHeaders.get(SIGNED_HEADERS));
        return sb.toString();
    }

    @Override
    public String getAuthorization(Signer signer, String accessKeyId, String signature) {
        return signer.getSignerName() + " Credential=" + accessKeyId + ",Signature=" + signature;
    }
}

