/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.StringUtils;
import darabonba.core.RequestConfiguration;
import darabonba.core.RequestModel;
import darabonba.core.RequestStyle;
import darabonba.core.utils.ModelUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TeaRequest {
    @NameInMap(value="product")
    private String product;
    @NameInMap(value="endpointRule")
    private String endpointRule;
    @NameInMap(value="endpointMap")
    private Map<String, String> endpointMap;
    @NameInMap(value="resource")
    private List<String> resource;
    @NameInMap(value="headers")
    private HttpHeaders headers;
    private Set<String> additionalHeaderNames;
    @NameInMap(value="query")
    private Map<String, String> query;
    @NameInMap(value="hostMap")
    private Map<String, String> hostMap;
    @NameInMap(value="body")
    private Object body;
    @NameInMap(value="stream")
    private InputStream stream;
    @NameInMap(value="action")
    private String action;
    @NameInMap(value="version")
    private String version;
    @NameInMap(value="pathname")
    private String pathname;
    @NameInMap(value="pathRegex")
    private String pathRegex = "/";
    @NameInMap(value="bodyType")
    private String bodyType = "json";
    @NameInMap(value="bodyIsForm")
    private Boolean bodyIsForm = false;
    @NameInMap(value="reqBodyType")
    private String reqBodyType = "json";
    @NameInMap(value="style")
    private RequestStyle style = RequestStyle.ANY;
    @NameInMap(value="configuration")
    private RequestConfiguration requestConfiguration;
    @NameInMap(value="method")
    private HttpMethod method = HttpMethod.GET;

    private TeaRequest() {
    }

    public static TeaRequest create() {
        return new TeaRequest();
    }

    public String product() {
        return this.product;
    }

    public TeaRequest setProduct(String product) {
        this.product = product;
        return this;
    }

    public String endpointRule() {
        return this.endpointRule;
    }

    public TeaRequest setEndpointRule(String endpointRule) {
        this.endpointRule = endpointRule;
        return this;
    }

    public Map<String, String> endpointMap() {
        return this.endpointMap;
    }

    public TeaRequest setEndpointMap(Map<String, String> endpointMap) {
        this.endpointMap = endpointMap;
        return this;
    }

    public List<String> resource() {
        return this.resource;
    }

    public TeaRequest setResource(List<String> resource) {
        this.resource = resource;
        return this;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public TeaRequest setHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Set<String> additionalHeaderNames() {
        return this.additionalHeaderNames;
    }

    public TeaRequest setAdditionalHeaderNames(Set<String> additionalHeaderNames) {
        this.additionalHeaderNames = additionalHeaderNames;
        return this;
    }

    public Map<String, String> query() {
        return this.query;
    }

    public TeaRequest setQuery(Map<String, String> query) {
        this.query = query;
        return this;
    }

    public Map<String, String> hostMap() {
        return this.hostMap;
    }

    public TeaRequest setHostMap(Map<String, String> hostMap) {
        this.hostMap = hostMap;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public TeaRequest setBody(Object body) {
        this.body = body;
        return this;
    }

    public InputStream stream() {
        return this.stream;
    }

    public TeaRequest setStream(InputStream stream) {
        this.stream = stream;
        return this;
    }

    public String action() {
        return this.action;
    }

    public TeaRequest setAction(String action) {
        this.action = action;
        return this;
    }

    public String version() {
        return this.version;
    }

    public TeaRequest setVersion(String version) {
        this.version = version;
        return this;
    }

    public String pathname() {
        return this.pathname;
    }

    public TeaRequest setPathname(String pathname) {
        this.pathname = pathname;
        return this;
    }

    public String pathRegex() {
        return this.pathRegex;
    }

    public TeaRequest setPathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
        return this;
    }

    public String bodyType() {
        return this.bodyType;
    }

    public TeaRequest setBodyType(String bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    public Boolean bodyIsForm() {
        return this.bodyIsForm;
    }

    public TeaRequest setBodyIsForm(Boolean bodyIsForm) {
        this.bodyIsForm = bodyIsForm;
        return this;
    }

    public String reqBodyType() {
        return this.reqBodyType;
    }

    public TeaRequest setReqBodyType(String reqBodyType) {
        this.reqBodyType = reqBodyType;
        return this;
    }

    public RequestStyle style() {
        return this.style;
    }

    public TeaRequest setStyle(RequestStyle style) {
        this.style = style;
        return this;
    }

    public RequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    public TeaRequest setRequestConfiguration(RequestConfiguration requestConfiguration) {
        this.requestConfiguration = requestConfiguration;
        return this;
    }

    public HttpMethod method() {
        return this.method;
    }

    public TeaRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public TeaRequest formModel(RequestModel model) throws Exception {
        this.query = ModelUtil.queryConvert(model);
        this.body = ModelUtil.bodyConvert(model, this.bodyIsForm);
        this.stream = ModelUtil.streamConvert(model);
        this.headers = new HttpHeaders(ModelUtil.headersConvert(model));
        this.pathname = ModelUtil.pathConvert(model, this.pathRegex());
        this.hostMap = ModelUtil.hostConvert(model);
        this.requestConfiguration = model.getRequestConfiguration();
        return this;
    }

    public TeaRequest copy() {
        return TeaRequest.create().setProduct(this.product).setEndpointRule(this.endpointRule).setEndpointMap(this.endpointMap).setVersion(this.version).setHeaders(this.headers).setQuery(this.query).setHostMap(this.hostMap).setBody(this.body).setStream(this.stream).setAction(this.action).setPathname(this.pathname).setPathRegex(this.pathRegex).setBodyType(this.bodyType).setBodyIsForm(this.bodyIsForm).setReqBodyType(this.reqBodyType).setStyle(this.style).setMethod(this.method).setRequestConfiguration(this.requestConfiguration);
    }

    public String toString() {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("product", this.product);
        fieldMap.put("action", this.action);
        fieldMap.put("version", this.version);
        fieldMap.put("headers", this.headers);
        fieldMap.put("pathname", this.pathname);
        fieldMap.put("bodyType", this.bodyType);
        fieldMap.put("reqBodyType", this.reqBodyType);
        fieldMap.put("style", (Object)this.style);
        return StringUtils.toAliString((String)"TeaRequest", fieldMap);
    }
}

