/*
 * Decompiled with CFR 0.152.
 */
package darabonba.core.sse;

import com.aliyun.core.utils.StringUtils;
import darabonba.core.ResponseIterator;
import darabonba.core.sse.Event;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class SSEResponseIterator<T>
extends ResponseIterator<T> {
    private volatile int retry = 3000;
    private volatile boolean endOfEvent = false;
    private final Queue<T> events = new LinkedList<T>();
    private final List<T> backoff = new ArrayList<T>();

    @Override
    public boolean hasNext() {
        if (this.endOfFailure) {
            throw new RuntimeException(this.throwable);
        }
        return !this.events.isEmpty() || !this.endOfEvent;
    }

    @Override
    public T next() {
        if (this.events.isEmpty()) {
            try {
                Thread.sleep(this.retry);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.events.poll();
    }

    public void addEvent(Event event) {
        String data;
        if (event.getRetry() > 0) {
            this.retry = event.getRetry();
        }
        if (!StringUtils.isEmpty((CharSequence)(data = event.getData()))) {
            T model = this.toModel(data);
            this.events.add(model);
            this.backoff.add(model);
        }
    }

    protected abstract T toModel(String var1);

    public void endOfEvent() {
        this.endOfEvent = true;
    }

    @Override
    public List<T> getAll() {
        return this.backoff;
    }
}

