package com.aliyun.openservices.iot.api.auth.handler;

import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

import java.util.Map;
import java.util.Random;

import static com.aliyun.openservices.iot.api.Constraint.*;

/**
 * AppKey authentication impl
 *
 * @author brhao
 * @date 10/07/2018
 */
public class AppKeyAuthHandler implements AuthHandler {
    private static final String PARAM_RANDOM = "param-random";
    private static final String SHA_256 = "SHA256";
    private static final String PARAM_SIGN_METHOD = "param-sign-method";
    private static final String PARAM_SIGN = "param-sign";

    private Map<String, String> params;

    public AppKeyAuthHandler(Map<String, String> authParams) {
        params = Maps.newHashMap();
        params.putAll(authParams);
        String appSecret = params.get(PARAM_APP_SECRET);
        String random = String.valueOf(new Random().nextLong());
        String signContent = "random=" + random;
        String sign = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, appSecret).hmacHex(signContent);

        params.put(AUTH_TYPE, AUTH_TYPE_APP_KEY);
        params.put(PARAM_SIGN, sign);
        params.put(PARAM_RANDOM, random);
        params.put(PARAM_SIGN_METHOD, SHA_256);
        params.remove(PARAM_APP_SECRET);
    }

    @Override
    public Map<String, String> getAuthParams() {
        return params;
    }
}
