package com.aliyun.openservices.iot.api.auth.handler;

import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

import java.util.Map;

import static com.aliyun.openservices.iot.api.Constraint.*;

/**
 * device authentication impl
 *
 * @author brhao
 * @date 10/07/2018
 */
public class DeviceAuthHandler implements AuthHandler {
    private static final String PARAM_SIGN = "param-sign";
    private static final String PARAM_SIGNMETHOD = "param-signmethod";
    private static final String HMACMD5 = "hmacmd5";
    private static final String PARAM_TIMESTAMP = "param-timestamp";

    private Map<String, String> params;

    public DeviceAuthHandler(Map<String, String> authParams) {
        this.params = Maps.newHashMap();
        params.putAll(authParams);

        String now = String.valueOf(System.currentTimeMillis());
        String productKey = authParams.get(PARAM_PRODUCT_KEY);
        String deviceName = authParams.get(PARAM_DEVICE_NAME);
        String clientId = authParams.get(PARAM_CLIENT_ID);
        String deviceSecret = authParams.get(PARAM_DEVICE_SECRET);
        String signOrigin = "clientId" + clientId
                + "deviceName" + deviceName
                + "productKey" + productKey
                + "timestamp" + now;
        params.put(PARAM_TIMESTAMP, now);
        params.put(PARAM_SIGNMETHOD, HMACMD5);
        String sign = new HmacUtils(HmacAlgorithms.HMAC_MD5, deviceSecret).hmacHex(signOrigin);
        params.put(PARAM_SIGN, sign);
        params.remove(PARAM_DEVICE_SECRET);
    }

    @Override
    public Map<String, String> getAuthParams() {
        return params;
    }
}
