package com.aliyun.openservices.iot.api.auth.handler.accesskey;

import com.aliyun.openservices.iot.api.Constraint;
import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.aliyun.openservices.iot.api.exception.IotClientException;
import com.aliyun.openservices.iot.api.util.StringUtil;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * aliyun accessKey authentication impl
 *
 * @author brhao
 * @date 10/07/2018
 */
public class AccessKeyAuthHandler implements AuthHandler {
    private static final String PARAM_IOT_TOKEN = "param-token";
    private static final String PARAM_IOT_ID = "param-iot-id";
    private String iotId;
    private String token;
    private long validDuration;
    private long fetchTime;
    private IAcsClient client;

    public AccessKeyAuthHandler(Map<String, String> params) {
        String accessKey = params.get(Constraint.PARAM_ACCESS_KEY);
        String accessSecret = params.get(Constraint.PARAM_ACCESS_SECRET);
        String stsToken = params.get(Constraint.PARAM_STS_TOKEN);
        String regionId = params.get(Constraint.REGION_ID);
        try {
            DefaultProfile.addEndpoint(regionId, regionId, "iot", params.getOrDefault(Constraint.PARAM_ALIYUNCS_HOST, "iot." + regionId + ".aliyuncs.com"));
        } catch (ClientException e) {
            throw new IotClientException(e);
        }

        IClientProfile profile = null;
        if (StringUtil.isNotEmpty(stsToken)) {
            profile = DefaultProfile.getProfile(regionId, accessKey, accessSecret, stsToken);
        } else {
            profile = DefaultProfile.getProfile(regionId, accessKey, accessSecret);
        }

        client = new DefaultAcsClient(profile);
    }


    @Override
    public Map<String, String> getAuthParams() {
        if (System.currentTimeMillis() - fetchTime > validDuration) {
            updateToken();
        }
        Map<String, String> authParams = Maps.newHashMap();
        authParams.put(PARAM_IOT_TOKEN, token);
        authParams.put(PARAM_IOT_ID, iotId);
        authParams.put(Constraint.AUTH_TYPE, Constraint.AUTH_TYPE_ACCESS_KEY);
        return authParams;
    }

    private void updateToken() {
        RamAuthRequest ramAuthRequest = new RamAuthRequest();
        try {
            RamAuthResponse ramAuthResponse = client.getAcsResponse(ramAuthRequest);
            fetchTime = System.currentTimeMillis();
            validDuration = ramAuthResponse.getValidDuration();
            iotId = ramAuthResponse.getIotId();
            token = ramAuthResponse.getIotToken();
        } catch (ClientException e) {
            throw new IotClientException(e);
        }
    }
}