/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.openservices.iot.api.auth.handler.accesskey;

import com.aliyuncs.transform.UnmarshallerContext;

/**
 * @author auto create
 */
public class RamAuthResponseUnmarshaller {

    public static RamAuthResponse unmarshall(RamAuthResponse ramAuthResponse, UnmarshallerContext context) {

        ramAuthResponse.setRequestId(context.stringValue("RamAuthResponse.RequestId"));
        ramAuthResponse.setSuccess(context.booleanValue("RamAuthResponse.Success"));
        ramAuthResponse.setErrorMessage(context.stringValue("RamAuthResponse.ErrorMessage"));
        ramAuthResponse.setIotToken(context.stringValue("RamAuthResponse.IotToken"));
        ramAuthResponse.setValidDuration(context.longValue("RamAuthResponse.ValidDuration"));
        ramAuthResponse.setIotId(context.stringValue("RamAuthResponse.IotId"));

        return ramAuthResponse;
    }
}