/*
 * Copyright (C) 2014 Square, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.openservices.iot.api.http2.callback;

import com.aliyun.openservices.iot.api.http2.connection.Connection;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;

import java.io.IOException;

/**
 * @author brhao
 */
public interface Http2StreamListener {
    /**
     * callback for data receiving
     *
     * @param connection  connection
     * @param stream      stream
     * @param data        data
     * @param endOfStream endOfStream
     */
    void onDataRead(Connection connection, Http2Stream stream, byte[] data, boolean endOfStream);

    /**
     * callback for headers receiving
     *
     * @param connection  connection
     * @param stream      stream
     * @param headers     headers
     * @param endOfStream endOfStream
     */
    void onHeadersRead(Connection connection, Http2Stream stream, Http2Headers headers, boolean endOfStream);

    /**
     * callback for error.
     *
     * @param connection connection
     * @param stream     http2Stream
     * @param e          exception
     */
    void onStreamError(Connection connection, Http2Stream stream, IOException e);
}