package com.aliyun.openservices.iot.api.http2.connection;

import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection.PropertyKey;

/**
 * HTTP2 Connection
 *
 * @author brhao
 * @date 04/04/2018
 */
public interface Connection extends ConnectionWriter, ConnectionReader {
    /**
     * set listener for connection
     *
     * @param listener ConnectionListener
     */
    void setConnectionListener(ConnectionListener listener);

    /**
     * remove connection listener
     */
    void removeConnectListener();

    /**
     * callback when connection closed
     */
    void onConnectionClosed();

    /**
     * set connection status
     *
     * @param status status
     */
    void setStatus(ConnectionStatus status);

    /**
     * get connection status
     *
     * @return connection status
     */
    ConnectionStatus getStatus();

    /**
     * is connection authorized
     *
     * @return is connection authorized
     */
    boolean isAuthorized();

    /**
     * callback when error occurs
     *
     * @param ctx      ctx
     * @param outbound outbound
     * @param cause    cause
     */
    void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause);

    /**
     * get property key
     *
     * @param keyName keyName
     * @return propertyKey
     */
    PropertyKey getPropertyKey(String keyName);

    /**
     * set property
     *
     * @param key    propertyKey
     * @param object object
     */
    void setProperty(PropertyKey key, Object object);

    /**
     * get property
     *
     * @param key propertyKey
     * @return property
     */
    Object getProperty(PropertyKey key);

    /**
     * set default stream listener
     *
     * @param http2StreamListener listener
     */
    void setDefaultStreamListener(Http2StreamListener http2StreamListener);

    /**
     * close connection
     */
    void close();
}
