package com.aliyun.openservices.iot.api.http2.connection;

import io.netty.handler.codec.http2.Http2Settings;

/**
 * @author brhao
 * @date 30/03/2018
 */
public interface ConnectionListener {
    /**
     * callback for setting received
     *
     * @param connection connection
     * @param settings   Http2 Setting
     */
    void onSettingReceive(Connection connection, Http2Settings settings);

    /**
     * callback for status changed
     *
     * @param status     status
     * @param connection connection
     */
    void onStatusChange(ConnectionStatus status, Connection connection);
}
