package com.aliyun.openservices.iot.api.http2.connection;

import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * Connection Manager
 *
 * @author brhao
 * @date 19/03/2018
 */
public interface ConnectionManager {

    /**
     * get a connection
     *
     * @return connection list
     */
    List<Connection> getConnectionList();

    /**
     * connect
     *
     * @param address address
     * @return connection
     */
    CompletableFuture<Connection> connect(SocketAddress address);

    /**
     * shutdown
     * close all connection
     */
    void shutdown();

    /**
     * add connection listener
     *
     * @param connectionSettingListener listener for connection status changing
     */
    void addConnectionListener(ConnectionListener connectionSettingListener);

    /**
     * remove connection listener
     *
     * @param connectionSettingListener listener for connection status changing
     */
    void removeConnectionListener(ConnectionListener connectionSettingListener);
}
