package com.aliyun.openservices.iot.api.http2.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;

/**
 * @author brhao
 * @date 08/04/2018
 */
public interface ConnectionReader {

    /**
     * callback for DataFrame
     *
     * @param ctx         context
     * @param streamId    streamId
     * @param data        data
     * @param padding     padding
     * @param endOfStream end of stream
     * @return size of read
     */
    int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream);

    /**
     * callback for HeaderFrame
     *
     * @param ctx              context
     * @param streamId         streamId
     * @param headers          http2 Header
     * @param streamDependency stream dependency
     * @param weight           weight
     * @param exclusive        exclusive
     * @param padding          padding
     * @param endOfStream      end of stream
     */
    void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency,
                       short weight, boolean exclusive, int padding, boolean endOfStream);

    /**
     * callback for SettingFrame
     *
     * @param ctx      context
     * @param settings http2 setting
     */
    void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings);

    /**
     * callback for GoAway
     *
     * @param ctx          ctx
     * @param lastStreamId lastStreamId
     * @param errorCode    errorCode
     * @param debugData    debugData
     */
    void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData);

    /**
     * callback for rst
     *
     * @param ctx       ctx
     * @param streamId  streamId
     * @param errorCode errorCode
     */
    void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode);

    /**
     * callback for Unknown Frame
     *
     * @param ctx       ctx
     * @param frameType frameType
     * @param streamId  streamId
     * @param flags     flags
     * @param payload   payload
     */
    void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload);
}
