package com.aliyun.openservices.iot.api.http2.connection;

import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import io.netty.handler.codec.http2.Http2Headers;

import java.util.concurrent.CompletableFuture;

/**
 * @author brhao
 * @date 08/04/2018
 */
public interface ConnectionWriter {
    /**
     * Write HEADER frame
     *
     * @param headers             headers
     * @param endStream           end of stream
     * @param http2StreamListener stream listener
     * @return CompletableFuture for IO
     */
    public CompletableFuture<StreamWriteOperation> writeHeaders(Http2Headers headers, boolean endStream,
                                                                Http2StreamListener http2StreamListener);

    /**
     * Write DATA frame
     *
     * @param streamId  streamId
     * @param data      data
     * @param endStream end of stream
     * @return CompletableFuture for IO
     */
    public CompletableFuture<StreamWriteOperation> writeData(int streamId, byte[] data, boolean endStream);

    /**
     * Write GoAway frame
     *
     * @param lastStreamId lastStreamId
     * @param errorCode    errorCode
     * @param debugData    debugData
     * @return CompletableFuture for IO
     */
    public CompletableFuture<Connection> writeGoAway(int lastStreamId, int errorCode, byte[] debugData);

    /**
     * Write RST_STEAM frame
     *
     * @param streamId  streamId
     * @param errorCode errorCode
     * @return CompletableFuture for IO
     */
    public CompletableFuture<Connection> writeRst(int streamId, int errorCode);
}
