package com.aliyun.openservices.iot.api.http2.connection;

import io.netty.handler.codec.http2.Http2Stream;

import java.util.concurrent.CompletableFuture;

/**
 * @author brhao
 * @date 22/05/2018
 */
public class StreamWriteOperation {
    private Http2Stream stream;
    private Connection connection;

    public StreamWriteOperation(Http2Stream stream, Connection connection) {
        this.stream = stream;
        this.connection = connection;
    }

    /**
     * Write DATA frame
     *
     * @param data      data
     * @param endStream end of stream
     * @return CompletableFuture for IO
     */
    public CompletableFuture<StreamWriteOperation> writeData(byte[] data, boolean endStream) {
        return connection.writeData(stream.id(), data, endStream);
    }

    public void closeStream() {
        stream.close();
    }
}
