package com.aliyun.openservices.iot.api.http2.entity;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * @author brhao
 * @date 16/05/2018
 */
@Data
public class BaseHttpEntity {
    public static final String REQUEST_ID = "x-request-id";
    @Getter(AccessLevel.PUBLIC)
    @Setter(AccessLevel.PUBLIC)
    protected Http2Headers headers;
    protected byte[] content;

    public BaseHttpEntity() {
        headers = new DefaultHttp2Headers();
    }

    public BaseHttpEntity(Http2Headers headers, byte[] content) {
        this.headers = headers;
        this.content = content;
    }

    public String getRequestId() {
        return headers.get(REQUEST_ID).toString();
    }

    public void setRequestId(String id) {
        headers.set(REQUEST_ID, id);
    }
}
