package com.aliyun.openservices.iot.api.http2.entity;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import lombok.Data;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @author brhao
 * @date 19/03/2018
 */
@Data
public class StreamData {
    Http2Headers headers;
    List<byte[]> data;
    int dataSize;
    boolean endStream;

    public StreamData() {
        this.data = new ArrayList<>();
        this.headers = new DefaultHttp2Headers();
    }

    public void addData(byte[] bytes) {
        data.add(bytes);
        dataSize += bytes.length;
    }

    public byte[] readAllData() {
        if (dataSize == 0) {
            return new byte[0];
        }

        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(dataSize);
        for (byte[] bytes : data) {
            outputStream.write(bytes, 0, bytes.length);
        }

        return outputStream.toByteArray();
    }

    public void addHeaders(Http2Headers headers) {
        this.headers.add(headers);
    }

    public void clearData() {
        data.clear();
    }

    @Override
    public String toString() {
        return "headers: " + headers + ", content: " + new String(readAllData());
    }
}
