package com.aliyun.openservices.iot.api.http2.netty;

import io.netty.handler.codec.http2.*;
import io.netty.handler.logging.LogLevel;

import java.util.HashMap;
import java.util.Map;

/**
 * Netty Http2 handler builder
 * setup frameLogger and initialSetting
 *
 * @author brhao
 */
public class NettyHttp2HandlerBuilder extends AbstractHttp2ConnectionHandlerBuilder<NettyHttp2Handler,
        NettyHttp2HandlerBuilder> {
    private long heartbeatTimeoutThreshold;

    public NettyHttp2HandlerBuilder(long heartbeatTimeoutThreshold) {
        this.heartbeatTimeoutThreshold = heartbeatTimeoutThreshold;
        frameLogger(getFrameLogger());
    }

    @Override
    protected NettyHttp2Handler build() {
        return super.build();
    }

    @Override
    protected NettyHttp2Handler build(Http2ConnectionDecoder decoder,
                                      Http2ConnectionEncoder encoder,
                                      Http2Settings initialSettings) throws Exception {
        NettyHttp2Handler handler = new NettyHttp2Handler(decoder, encoder, initialSettings, heartbeatTimeoutThreshold);
        frameListener(handler);
        initialSettings().pushEnabled(true);
        initialSettings().initialWindowSize(1073741824);
        initialSettings().maxFrameSize(1024 * 1024);
        return handler;
    }

    private Http2FrameLogger getFrameLogger() {
        LogLevel logLevel = logLevelMap.getOrDefault(frameLogLevel.toLowerCase(), LogLevel.INFO);
        return new Http2FrameLogger(logLevel, getClass());
    }

    @Override
    protected boolean isServer() {
        return false;
    }

    private String frameLogLevel = "debug";

    private Map<String, LogLevel> logLevelMap = new HashMap<String, LogLevel>() {{
        put("trace", LogLevel.TRACE);
        put("debug", LogLevel.DEBUG);
        put("info", LogLevel.INFO);
        put("warn", LogLevel.WARN);
        put("error", LogLevel.ERROR);
    }};

}
