package com.aliyun.openservices.iot.api.http2.netty;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import lombok.extern.slf4j.Slf4j;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

/**
 * netty initializer
 * only support h2
 *
 * @author brhao
 * @date 2018/03/20 11:09
 */
@Slf4j
public class NettyHttp2Initializer extends ChannelInitializer<SocketChannel> {
    private static final String TLS_PROTOCOL_VERSION_1_2 = "TLSv1.2";
    private NettyHttp2HandlerBuilder handlerBuilder;
    private boolean enableSsl = false;
    private SSLContext sslContext;

    public NettyHttp2Initializer(NettyHttp2HandlerBuilder handlerBuilder, boolean enableSsl)
            throws NoSuchAlgorithmException, KeyManagementException {
        this.handlerBuilder = handlerBuilder;
        this.enableSsl = enableSsl;
    }

    @Override
    protected void initChannel(SocketChannel ch)
            throws NoSuchAlgorithmException, KeyManagementException, IOException, KeyStoreException, CertificateException {
        log.info("init http2 handler. enable SSL : {}", enableSsl);
        if (enableSsl) {
            if (sslContext == null) {
                sslContext = SSLContext.getInstance(TLS_PROTOCOL_VERSION_1_2);

                Certificate ca;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");

                try (InputStream in = this.getClass().getResourceAsStream("/root.crt")) {
                    ca = cf.generateCertificate(in);
                }
                String keyStoreType = KeyStore.getDefaultType();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", ca);
                String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                tmf.init(keyStore);

                // TODO use root.crt
                sslContext.init(null, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            ch.pipeline().addLast(new SslHandler(sslEngine));
        }
        ch.pipeline().addLast(handlerBuilder.build());
    }
}
