package com.aliyun.openservices.iot.api.stream;

import com.aliyun.openservices.iot.api.http2.IotHttp2Client;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.StreamWriteOperation;
import com.aliyun.openservices.iot.api.http2.entity.BaseHttpEntity;
import com.aliyun.openservices.iot.api.http2.entity.Http2Response;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Headers.PseudoHeaderName;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.CompletableFuture;

import static com.aliyun.openservices.iot.api.util.StreamUtil.DATA_STREAM_ID;

/**
 * @author brhao
 * @date 16/05/2018
 */
@Slf4j
public class StreamServiceContext {
    public static final String RESPONSE_STATUS = "x-response-status";

    private BaseHttpEntity sourceRequest;
    private Connection connection;
    private IotHttp2Client client;
    @Getter
    private String serviceName;

    public StreamServiceContext(IotHttp2Client client, Connection connection, BaseHttpEntity request,
                                String serviceName) {
        this.client = client;
        this.connection = connection;
        this.sourceRequest = request;
        this.serviceName = serviceName;
    }

    public void writeResponse(Http2Response response) {

        Http2Headers headers = response.getHeaders();
        headers.add(BaseHttpEntity.REQUEST_ID, sourceRequest.getRequestId());
        headers.add(RESPONSE_STATUS, headers.status());
        headers.add(DATA_STREAM_ID, getStreamId());
        headers.path(sourceRequest.getHeaders().path());
        headers.method("POST");
        headers.scheme("https");
        headers.remove(PseudoHeaderName.STATUS.value());

        byte[] data = response.getContent();

        CompletableFuture<StreamWriteOperation> future;
        boolean endOfStream = (data == null || data.length == 0);
        future = connection.writeHeaders(headers, endOfStream, null);

        if (!endOfStream) {
            future.thenAccept(writeOperation -> writeOperation.writeData(response.getContent(), true));
        }

        future.thenAccept(StreamWriteOperation::closeStream);
    }

    public String getStreamId() {
        if (sourceRequest.getHeaders().contains(DATA_STREAM_ID)) {
            return sourceRequest.getHeaders().get(DATA_STREAM_ID).toString();
        }
        return null;
    }

    public Connection getConnection() {
        return connection;
    }

    public void updateContext(BaseHttpEntity httpEntity) {
        this.sourceRequest.getHeaders().add(httpEntity.getHeaders());
        this.sourceRequest.getHeaders().set(BaseHttpEntity.REQUEST_ID, httpEntity.getRequestId());
    }
}
