package com.aliyun.openservices.iot.api.util;

import com.aliyun.openservices.iot.api.exception.IotClientException;
import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.stream.StreamServiceContext;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http2.Http2Connection.PropertyKey;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author brhao
 * @date 16/05/2018
 */
public class StreamUtil {
    public static final String PATH_STREAM_REGISTER = "/stream/register";
    public static final String PATH_STREAM_UNREGISTER = "/stream/unregister";
    public static final String PATH_STREAM_OPEN = "/stream/open";
    public static final String PATH_STREAM_CLOSE = "/stream/close";
    public static final String PATH_STREAM_SEND = "/stream/send";
    public static final String DATA_STREAM_ID = "x-data-stream-id";

    public static void setupConnection(Connection connection, Http2StreamListener http2StreamListener) {
        connection.setDefaultStreamListener(http2StreamListener);
        PropertyKey key = connection.getPropertyKey("streams");
        connection.setProperty(key, Maps.newConcurrentMap());
    }

    @SuppressWarnings("unchecked")
    public static Map<String, StreamServiceContext> connectionStreams(Connection connection) {
        PropertyKey key = connection.getPropertyKey("streams");
        return (Map<String, StreamServiceContext>) connection.getProperty(key);
    }

    public static StreamServiceContext getStreamContext(List<Connection> connections, String streamId) {
        Optional<StreamServiceContext> optional = connections.stream()
                .filter(c -> hasStream(c, streamId))
                .findFirst()
                .map(c -> getStreamContext(c, streamId));
        if (!optional.isPresent()) {
            throw new IotClientException("stream id [" + streamId + "] not exist");
        }
        return optional.get();
    }

    private static boolean hasStream(Connection connection, String streamId) {
        if (connectionStreams(connection) == null) {
            return false;
        }
        return connectionStreams(connection).containsKey(streamId);
    }

    public static void putStreamContext(Connection connection, String streamId, StreamServiceContext context) {
        connectionStreams(connection).put(streamId, context);
    }

    private static StreamServiceContext getStreamContext(Connection connection, String streamId) {
        return connectionStreams(connection).get(streamId);
    }

    public static void removeStreamContext(Connection connection, String streamId) {
        connectionStreams(connection).remove(streamId);
    }
}
