/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2;

import com.aliyun.openservices.iot.api.Profile;
import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.aliyun.openservices.iot.api.auth.AuthenticationFactory;
import com.aliyun.openservices.iot.api.http2.callback.AbstractHttp2StreamDataReceiver;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionListener;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionManager;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionStatus;
import com.aliyun.openservices.iot.api.http2.connection.impl.ConnectionManagerImpl;
import com.aliyun.openservices.iot.api.http2.entity.Http2Response;
import com.aliyun.openservices.iot.api.http2.entity.StreamData;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IotHttp2Client {
    private static final Logger log = LoggerFactory.getLogger(IotHttp2Client.class);
    public static final int CONNECTION_COUNT_UNLIMITED = -1;
    private final SocketAddress SOCKET_ADDRESS;
    private static final char SETTINGS_SUBSCRIBE_CONNECTION_COUNT = 'c';
    private static long[] reconnectInterval = new long[]{0L, 1000L, 10000L, 60000L, 600000L};
    private int reconnectFailedCount = 0;
    private AtomicInteger connectionCount = new AtomicInteger(1);
    private int maxConnectionCount = -1;
    private ScheduledExecutorService executorService;
    private AtomicBoolean started = new AtomicBoolean(false);
    private ConnectionManager connectionManager;
    private AuthHandler authHandler;
    private ConnectionListener connectionSettingListener = new ConnectionListener(){

        @Override
        public void onSettingReceive(Connection connection, Http2Settings settings) {
            if (!settings.containsKey('c')) {
                return;
            }
            int value = settings.getIntValue('c');
            if (IotHttp2Client.this.maxConnectionCount != -1 && IotHttp2Client.this.maxConnectionCount >= 0) {
                value = Math.min(IotHttp2Client.this.maxConnectionCount, value);
                log.info("maxConnectionCount: {}, server setting: {}", (Object)IotHttp2Client.this.maxConnectionCount, (Object)value);
            }
            IotHttp2Client.this.connectionCount.set(value);
            log.info("receive setting, connection: {}, subscription count : {} ", (Object)connection, (Object)IotHttp2Client.this.connectionCount);
        }

        @Override
        public void onStatusChange(ConnectionStatus status, Connection connection) {
            log.info("connection status changed, connection: {}, status: {}", (Object)connection, (Object)status);
            if (status == ConnectionStatus.AUTHORIZED && IotHttp2Client.this.started.compareAndSet(false, true) && IotHttp2Client.this.executorService != null) {
                IotHttp2Client.this.executorService.scheduleWithFixedDelay(() -> IotHttp2Client.this.updateConnectionCount(), 10000L, 10000L, TimeUnit.MILLISECONDS);
            }
            if (connection.getStatus() == ConnectionStatus.AUTHORIZED && status == ConnectionStatus.CLOSED) {
                IotHttp2Client.this.executorService.submit(() -> IotHttp2Client.this.updateConnectionCount());
            }
        }
    };

    public IotHttp2Client(Profile profile, int maxConnectionCount) {
        this.SOCKET_ADDRESS = new InetSocketAddress(profile.getHost(), profile.getPort());
        this.connectionManager = new ConnectionManagerImpl(true, profile.getHeartBeatInterval(), profile.getHeartBeatTimeOut());
        this.connectionManager.addConnectionListener(this.connectionSettingListener);
        this.maxConnectionCount = maxConnectionCount;
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("iot-client-thread-%d").build());
        this.authHandler = AuthenticationFactory.getAuthHandler(profile);
    }

    private void updateConnectionCount() {
        long current = this.allConnections().size();
        int expected = this.connectionCount.get();
        if (this.maxConnectionCount >= 0) {
            expected = Math.min(this.maxConnectionCount, expected);
        }
        if (current >= (long)expected) {
            return;
        }
        log.info("update connection count, current count {}, expected count {}", (Object)current, (Object)expected);
        if (this.reconnectFailedCount != 0) {
            long interval = reconnectInterval[this.reconnectFailedCount % reconnectInterval.length];
            try {
                log.info("backoff, create connection after {}ms", (Object)interval);
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                log.error("error occurs while backoff, exception: ", (Throwable)e);
            }
        }
        int i = 0;
        while ((long)i < (long)expected - current) {
            try {
                this.newConnection();
            }
            catch (Throwable t) {
                ++this.reconnectFailedCount;
                log.error("failed to create connection, {}", (Object)t.getMessage());
            }
            ++i;
        }
        long updatedCount = this.allConnections().size();
        if (updatedCount == (long)expected) {
            this.reconnectFailedCount = 0;
        }
        log.info("finish updating connection count, current count {}", (Object)updatedCount);
    }

    public Connection newConnection() throws ExecutionException, InterruptedException {
        return this.connectionManager.connect(this.SOCKET_ADDRESS).get();
    }

    public Http2Headers authHeader() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Map<String, String> authParams = this.authHandler.getAuthParams();
        authParams.forEach((arg_0, arg_1) -> IotHttp2Client.lambda$authHeader$0((Http2Headers)headers, arg_0, arg_1));
        return headers;
    }

    public void shutdown() {
        log.info("shutdown http2 client");
        this.allConnections().forEach(Connection::removeConnectListener);
        this.connectionManager.removeConnectionListener(this.connectionSettingListener);
        this.connectionManager.shutdown();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionManager.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionManager.removeConnectionListener(listener);
    }

    public List<Connection> allConnections() {
        return this.connectionManager.getConnectionList();
    }

    public CompletableFuture<Http2Response> sendRequest(Connection connection, Http2Headers headers, byte[] data) {
        final CompletableFuture<Http2Response> completableFuture = new CompletableFuture<Http2Response>();
        boolean endOfStream = false;
        int contentLength = 0;
        if (data == null || data.length == 0) {
            endOfStream = true;
        } else {
            contentLength = data.length;
        }
        headers.set((Object)"content-length", (Object)String.valueOf(contentLength));
        CompletionStage writeCompletableFuture = connection.writeHeaders(headers, endOfStream, new AbstractHttp2StreamDataReceiver(){

            @Override
            public void onDataRead(Connection connection, Http2Stream stream, StreamData streamData) {
                completableFuture.complete(new Http2Response(streamData.getHeaders(), streamData.readAllData()));
            }

            @Override
            public void onStreamError(Connection connection, Http2Stream stream, IOException e) {
                completableFuture.completeExceptionally(e);
            }
        }).whenComplete((c, throwable) -> {
            if (throwable != null) {
                completableFuture.completeExceptionally((Throwable)throwable);
            }
        });
        if (data != null) {
            ((CompletableFuture)writeCompletableFuture).thenAccept(writeOperation -> writeOperation.writeData(data, true).whenComplete((o, t) -> {
                if (t != null) {
                    completableFuture.completeExceptionally((Throwable)t);
                }
            }));
        }
        return completableFuture;
    }

    public Optional<Connection> randomConnection(Predicate<Connection> predicate) {
        List authConnection = this.allConnections().stream().filter(predicate).collect(Collectors.toList());
        if (authConnection.isEmpty()) {
            return Optional.empty();
        }
        Random r = new Random();
        return Optional.of(authConnection.get(r.nextInt(authConnection.size())));
    }

    private static /* synthetic */ void lambda$authHeader$0(Http2Headers headers, String key, String value) {
        Http2Headers cfr_ignored_0 = (Http2Headers)headers.set((Object)("x-auth-" + key), (Object)value);
    }
}

