/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.http2.connection.impl;

import com.aliyun.openservices.iot.api.exception.IotClientException;
import com.aliyun.openservices.iot.api.http2.callback.Http2StreamListener;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionListener;
import com.aliyun.openservices.iot.api.http2.connection.ConnectionStatus;
import com.aliyun.openservices.iot.api.http2.connection.StreamWriteOperation;
import com.aliyun.openservices.iot.api.http2.netty.NettyHttp2Handler;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(ConnectionImpl.class);
    private final Http2Connection.PropertyKey STREAM_LISTENER_KEY;
    private Http2Connection http2Connection;
    private ChannelHandlerContext ctx;
    private Http2ConnectionDecoder decoder;
    private Http2ConnectionEncoder encoder;
    private ConnectionListener connectionListener;
    private ConnectionStatus status;
    private Map<String, Http2Connection.PropertyKey> propertyKeyMap;

    public ConnectionImpl(NettyHttp2Handler nettyHttp2Handler, ChannelHandlerContext ctx) {
        this.http2Connection = nettyHttp2Handler.connection();
        this.decoder = nettyHttp2Handler.decoder();
        this.encoder = nettyHttp2Handler.encoder();
        this.ctx = ctx;
        this.STREAM_LISTENER_KEY = this.http2Connection.newKey();
        this.propertyKeyMap = Maps.newConcurrentMap();
    }

    private void setStreamListener(Http2Stream stream, Http2StreamListener http2StreamListener) {
        log.debug("set stream listener for streamId:{}", (Object)stream.id());
        stream.setProperty(this.STREAM_LISTENER_KEY, (Object)http2StreamListener);
    }

    private Http2Stream stream(int id) {
        return this.http2Connection.stream(id);
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        byte[] bytes;
        Http2Stream stream = this.stream(streamId);
        int readableSize = data.readableBytes();
        if (padding == 0 && data.hasArray()) {
            bytes = data.array();
        } else {
            int dataSize = readableSize - padding;
            byte[] temp = new byte[readableSize];
            data.readBytes(temp, 0, readableSize);
            bytes = padding == 0 ? temp : Arrays.copyOf(temp, dataSize);
        }
        this.streamCallbackApply(stream, streamService -> streamService.onDataRead(this, stream, bytes, endOfStream));
        return readableSize;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        boolean r;
        Http2Stream stream = this.stream(streamId);
        if (!this.streamListener(stream).isPresent()) {
            this.defaultStreamListener().ifPresent(l -> this.setStreamListener(stream, (Http2StreamListener)l));
        }
        if (!(r = this.streamCallbackApply(stream, streamService -> streamService.onHeadersRead(this, stream, headers, endOfStream)))) {
            this.writeGoAway(streamId, 2, ("no handler for stream " + streamId).getBytes());
        }
    }

    private Optional<Http2StreamListener> defaultStreamListener() {
        return this.streamListener(this.http2Connection.connectionStream());
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
        if (listener != null) {
            listener.onStatusChange(this.getStatus(), this);
        }
    }

    @Override
    public void removeConnectListener() {
        this.setConnectionListener(null);
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        if (this.connectionListener != null) {
            this.connectionListener.onSettingReceive(this, settings);
        }
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        this.streamCallbackApply(this.stream(streamId), l -> l.onStreamError(this, this.stream(streamId), new IOException("rst frame received, code : " + errorCode)));
    }

    @Override
    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
        this.streamCallbackApply(this.stream(streamId), l -> l.onStreamError(this, this.stream(streamId), new IOException("unknown frame received, hex dump: " + ByteBufUtil.hexDump((ByteBuf)payload))));
    }

    @Override
    public void onConnectionClosed() {
        this.setStatus(ConnectionStatus.CLOSED);
    }

    @Override
    public void setStatus(ConnectionStatus status) {
        if (this.connectionListener != null) {
            this.connectionListener.onStatusChange(status, this);
        }
        this.status = status;
    }

    @Override
    public ConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isAuthorized() {
        return this.status.equals((Object)ConnectionStatus.AUTHORIZED);
    }

    public String toString() {
        return this.ctx.channel().id().asShortText();
    }

    private Optional<Http2StreamListener> streamListener(Http2Stream stream) {
        return Optional.ofNullable(stream.getProperty(this.STREAM_LISTENER_KEY));
    }

    @Override
    public void onError(ChannelHandlerContext ctx, boolean outbound, Throwable cause) {
        try {
            this.http2Connection.forEachActiveStream(stream -> {
                this.streamCallbackApply(stream, l -> l.onStreamError(this, stream, new IOException(cause)));
                return true;
            });
        }
        catch (Http2Exception e) {
            log.error("error occurs when notify listener. exception: ", (Throwable)e);
        }
    }

    @Override
    public Http2Connection.PropertyKey getPropertyKey(String keyName) {
        return this.propertyKeyMap.computeIfAbsent(keyName, name -> this.http2Connection.newKey());
    }

    @Override
    public void setProperty(Http2Connection.PropertyKey key, Object object) {
        this.http2Connection.connectionStream().setProperty(key, object);
    }

    @Override
    public Object getProperty(Http2Connection.PropertyKey key) {
        return this.http2Connection.connectionStream().getProperty(key);
    }

    @Override
    public void setDefaultStreamListener(Http2StreamListener http2StreamListener) {
        this.setStreamListener(this.http2Connection.connectionStream(), http2StreamListener);
    }

    @Override
    public void close() {
        this.ctx.close().syncUninterruptibly();
    }

    private boolean streamCallbackApply(Http2Stream stream, Consumer<Http2StreamListener> f) {
        Optional<Http2StreamListener> optional = this.streamListener(stream);
        if (!optional.isPresent()) {
            return false;
        }
        Http2StreamListener streamService = optional.get();
        f.accept(streamService);
        return true;
    }

    @Override
    public CompletableFuture<StreamWriteOperation> writeHeaders(Http2Headers headers, boolean endStream, Http2StreamListener http2StreamListener) {
        return this.doInEventLoop((cf, channelPromise) -> {
            log.debug("write headers {}", (Object)headers);
            int streamId = this.http2Connection.local().incrementAndGetNextStreamId();
            Http2Stream stream = this.http2Connection.stream(streamId);
            if (stream == null) {
                try {
                    stream = this.http2Connection.local().createStream(streamId, false);
                }
                catch (Http2Exception e) {
                    throw new IotClientException(e);
                }
            }
            if (http2StreamListener != null) {
                this.setStreamListener(stream, http2StreamListener);
            }
            cf.setResult(new StreamWriteOperation(stream, this));
            this.encoder.writeHeaders(this.ctx, streamId, headers, 0, endStream, channelPromise);
            this.ctx.pipeline().flush();
        });
    }

    @Override
    public CompletableFuture<StreamWriteOperation> writeData(int streamId, byte[] data, boolean endStream) {
        return this.doInEventLoop((cf, channelPromise) -> {
            log.info("write data on connection {}, stream id: {}, size : {}", new Object[]{this.ctx.channel().id(), streamId, data.length});
            cf.setResult(new StreamWriteOperation(this.http2Connection.stream(streamId), this));
            this.encoder.writeData(this.ctx, streamId, Unpooled.wrappedBuffer((byte[])data), 0, endStream, channelPromise);
            this.ctx.pipeline().flush();
        });
    }

    @Override
    public CompletableFuture<Connection> writeRst(int streamId, int errorCode) {
        return this.doInEventLoop((cf, channelPromise) -> {
            log.info("write data on connection {}, stream id: {}, error code: {}", new Object[]{this.ctx.channel().id(), streamId, errorCode});
            cf.setResult(this);
            this.encoder.writeRstStream(this.ctx, streamId, (long)errorCode, channelPromise);
            this.ctx.pipeline().flush();
        });
    }

    @Override
    public CompletableFuture<Connection> writeGoAway(int lastStreamId, int errorCode, byte[] debugData) {
        return this.doInEventLoop((cf, channelPromise) -> {
            log.info("write goaway on connection {}, stream id: {}, size : {}", new Object[]{this.ctx.channel().id(), lastStreamId, debugData.length});
            cf.setResult(this);
            this.encoder.writeGoAway(this.ctx, lastStreamId, (long)errorCode, Unpooled.wrappedBuffer((byte[])debugData), channelPromise);
            this.ctx.pipeline().flush();
        });
    }

    private <R> CompletableFuture<R> doInEventLoop(BiConsumer<CompletableFutureBridge<R>, ChannelPromise> consumer) {
        CompletableFutureBridge cf = new CompletableFutureBridge();
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener(future -> {
            if (future.isSuccess()) {
                cf.complete();
            } else {
                cf.completeExceptionally(future.cause());
            }
        });
        if (this.ctx.channel().eventLoop().inEventLoop()) {
            consumer.accept(cf, promise);
            return cf;
        }
        CompletableFuture.runAsync(() -> consumer.accept(cf, promise), (Executor)this.ctx.channel().eventLoop()).whenComplete((f, t) -> {
            if (t != null) {
                cf.completeExceptionally((Throwable)t);
            }
        });
        return cf;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    class CompletableFutureBridge<T>
    extends CompletableFuture<T> {
        private T result;

        CompletableFutureBridge() {
        }

        void complete() {
            this.complete(this.result);
        }

        public void setResult(T result) {
            this.result = result;
        }
    }
}

